(()=>{var e=[e=>{e.exports="#version 300 es\nin vec2 a_position;out vec4 position;void main(){gl_Position=vec4(a_position,0,1);}"},e=>{e.exports="#version 300 es\nprecision highp float;uniform sampler2D texture;out vec4 outColor;void main(){vec4 col=texelFetch(texture,ivec2(gl_FragCoord.xy),0);col.a=1.;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float fov;uniform vec3 camera;uniform vec3 target;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform vec3 cuberot;uniform vec3 cuberot2;uniform vec3 cuberot3;uniform vec3 cuberot4;uniform vec3 cubepos;uniform float ambience;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float Sphere(vec3 pos,float radius){return length(pos)-radius;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=30.;vec3 volumetric=vec3(0.);vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}O map(vec3 pos){vec2 id=floor(pos.xz/2.+0.5);vec3 cr=length(id)<0.5?cuberot:length(id)<1.5?cuberot2:length(id)<2.5?cuberot3:cuberot4;vec3 cubePos=Repeat(pos+cubepos,vec3(2.,0.,2.))*Rot(cr.x,cr.y,cr.z);O cube=O(RoundBox(cubePos,vec3(0.5),0.05),1.,vec3(0.,0.9,0.));O ground=O(Ground(pos,0.),0.,pos);return Union(ground,cube);}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){volumetric+=vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec2 fr=fract(result.worldPosition.xz);float id=length(fr.x-0.5)+length(fr.y-0.5);vec3 color=mix(${color2},${color3},smoothstep(0.49,0.5,id));col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));vec3 refCol=vec3(0.);vec3 refRd=reflect(rayDir,normal);MarchResult reflectMarch=raymarch(p+normal*STEP_LOW,refRd);if(reflectMarch.O.mat<-0.5){}else if(reflectMarch.O.mat<0.5){}else if(reflectMarch.O.mat<1.5){vec3 rp=reflectMarch.worldPosition;vec3 rnormal=reflectMarch.normal;vec3 color=${color1};refCol=color*(ambience+0.5*Diffuse(rp,light1,rnormal));}MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));col=mix(refCol,col,0.20);col*=0.5+0.5*smoothstep(0.,0.1,shadowMarch.worldPosition.x);}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=vec3(1.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/MAXDIST;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST*3./4.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform vec3 camera;uniform vec3 target;uniform float fov;uniform vec4 hammerRotation;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform float phase;uniform float noiseMultiplier;uniform float volumetricStepMultiplier;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}mat2 Rot2D(float a){return mat2(cos(a),-sin(a),sin(a),cos(a));}vec2 Rot2DPoint(vec2 p,float a){return Rot2D(a)*p;}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float BoxFrame(vec3 p,vec3 b,float e){p=abs(p)-b;vec3 q=abs(p+e)-e;return min(min(length(max(vec3(p.x,q.y,q.z),0.))+min(max(p.x,max(q.y,q.z)),0.),length(max(vec3(q.x,p.y,q.z),0.))+min(max(q.x,max(p.y,q.z)),0.)),length(max(vec3(q.x,q.y,p.z),0.))+min(max(q.x,max(q.y,p.z)),0.));}float Sphere(vec3 pos,float radius){return length(pos)-radius;}float Torus(vec3 pos,vec2 t){vec2 q=vec2(length(pos.xz)-t.x,pos.y);return length(q)-t.y;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}O SmoothUnion(O a,O b,float k){float h=clamp(0.5+0.5*(b.dist-a.dist)/k,0.,1.);float dist=mix(b.dist,a.dist,h)-k*h*(1.-h);float s=step(b.dist,a.dist);return O(dist,mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}float Subtraction(float a,float b){return max(-b,a);}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}vec3 volumetric=vec3(0.);vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}float gyroid_3(vec3 seed){return dot(cos(seed),sin(seed.zxy));}float fbm_3(vec3 p){float t=0.;float a=.5;for(int i=0;i<12;++i){p.z-=(time*0.+t*.3);p.y-=time*0.+t*.3;t+=abs(gyroid_3(p/a))*a;a*=.5;}return t;}O mapHammer(vec3 pos){return O(RoundBox(pos,vec3(0.1),0.1),1.,pos);}O mapBelt(vec3 pos){vec3 size=vec3(10.,0.5,0.5);vec3 offset=vec3(0.,1.,1.);O result=O(RoundBox(pos,size,0.),0.,pos);result=Union(result,O(RoundBox(pos-offset,size,0.),0.,pos));result=Union(result,O(RoundBox(pos-offset*2.,size,0.),0.,pos));result=Union(result,O(RoundBox(pos-offset*3.,size,0.),0.,pos));result=Union(result,O(RoundBox(pos-offset*4.,size,0.),0.,pos));result=Union(result,O(RoundBox(pos-offset*5.,size,0.),0.,pos));return result;}O mapFumes(vec3 pos){vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);O fumes=mapBelt(pos+vec3(0.,-1.5,1.5));fumes.dist-=noise*noiseMultiplier;fumes.mat=11.;return fumes;}O mapFumes2(vec3 pos){vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);float dist=BoxFrame(pos,vec3(1.),0.2);dist=min(dist,RoundBox(pos,vec3(.5),0.));dist-=noise*noiseMultiplier;O bg=O(RoundBox(pos+vec3(0.,0.,10.),vec3(25.5,25.,2.),0.)-noise*.2,12.,pos);return Union(O(dist,11.,pos),bg);}O mapFumes3(vec3 pos){pos.x+=0.5;vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);float dist=RoundBox(pos,vec3(.1,1.4,0.5),0.);dist=min(dist,RoundBox(pos+vec3(-0.6,.8,0.),vec3(.8,.05,0.5),0.));pos=RotPointZ(pos,PI*.15);dist=min(dist,RoundBox(pos+vec3(-.75,.5,0.),vec3(.1,1.6,0.5),0.));dist-=noise*noiseMultiplier;O bg=O(RoundBox(pos+vec3(0.,0.,10.),vec3(25.5,25.,2.),0.)-noise*.2,12.,pos);return Union(O(dist,11.,pos),bg);}O mapFumes4(vec3 pos){vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);pos=RotPointZ(pos,PI*.25);float dist=RoundBox(pos,vec3(0.1,1.,1.),0.);pos=RotPointZ(pos,PI*.5);dist=min(dist,RoundBox(pos,vec3(0.1,1.,1.),0.));dist-=noise*noiseMultiplier;O bg=O(RoundBox(pos+vec3(0.,0.,10.),vec3(25.5,25.,2.),0.)-noise*.2,12.,pos);return Union(O(dist,11.,pos),bg);}O mapCube(vec3 pos){vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);O box=O(Sphere(pos+vec3(0.,-5.,0.),.25)-noise*.5,12.,pos);return box;}O mapExhibition(vec3 pos){float letterDepth=.4;vec3 seed=pos;vec3 p_o=pos;seed.z-=time;float noise=fbm_3(seed*.5);float distE=RoundBox(pos,vec3(0.1,1.,letterDepth),0.);distE=min(distE,RoundBox(pos+vec3(-.5,-1.,0.),vec3(0.5,0.1,letterDepth),0.));distE=min(distE,RoundBox(pos+vec3(-.5,0.,0.),vec3(0.5,0.1,letterDepth),0.));distE=min(distE,RoundBox(pos+vec3(-.5,1.,0.),vec3(0.5,0.1,letterDepth),0.));pos=p_o;pos-=vec3(2.5,-0.5,0.);pos=RotPointZ(pos,PI*.25);float distX=RoundBox(pos,vec3(0.1,1.,letterDepth),0.);pos=RotPointZ(pos,PI*.5);distX=min(distX,RoundBox(pos,vec3(0.1,1.,letterDepth),0.));pos=p_o;pos-=vec3(4.,-0.2,0.);float distH=RoundBox(pos,vec3(0.1,1.,letterDepth),0.);distH=min(distH,RoundBox(pos+vec3(-.5,0.,0.),vec3(0.5,0.1,letterDepth),0.));distH=min(distH,RoundBox(pos+vec3(-1,0.5,0.),vec3(0.1,0.5,letterDepth),0.));pos=p_o;pos-=vec3(6.,-0.,0.);float distI=RoundBox(pos+vec3(0.,0.6,0.),vec3(0.1,.4,letterDepth),0.);distI=min(distI,Sphere(pos+vec3(0.,-0.8,0.),.2));pos=p_o;pos-=vec3(7.,-0.,0.);float distB=RoundBox(pos,vec3(0.1,1.,letterDepth),0.);distB=min(distB,Sphere(pos+vec3(-0.5,.8,0.),.5));pos=p_o;pos-=vec3(8.5,-0.,0.);float distI2=RoundBox(pos+vec3(0.,0.6,0.),vec3(0.1,.4,letterDepth),0.);distI2=min(distI2,Sphere(pos+vec3(0.,-0.8,0.),.2));pos=p_o;pos-=vec3(9.8,-0.,0.);float distT=RoundBox(pos,vec3(0.1,1.,letterDepth),0.);distT=min(distT,RoundBox(pos+vec3(0.,-0.4,0.),vec3(.7,0.05,letterDepth),0.));pos=p_o;pos-=vec3(11.2,-0.,0.);float distI3=RoundBox(pos+vec3(0.,0.6,0.),vec3(0.1,.4,letterDepth),0.);distI3=min(distI3,Sphere(pos+vec3(0.,-0.8,0.),.2));pos=p_o;pos-=vec3(13.,-0.,0.);pos=RotPointX(pos,PI*.5);float distO=Torus(pos,vec2(.7,0.1));pos=p_o;pos-=vec3(15.,-0.,0.);float distN=RoundBox(pos+vec3(0.,0.25,0.),vec3(0.1,.5,letterDepth),0.);distN=min(distN,RoundBox(pos+vec3(-.5,0.,0.),vec3(0.5,0.1,letterDepth),0.));distN=min(distN,RoundBox(pos+vec3(-1,0.5,0.),vec3(0.1,0.5,letterDepth),0.));float dist=distE;dist=min(dist,distX);dist=min(dist,distH);dist=min(dist,distI);dist=min(dist,distB);dist=min(dist,distI2);dist=min(dist,distT);dist=min(dist,distI3);dist=min(dist,distO);dist=min(dist,distN);dist-=noise*noiseMultiplier;O bg=O(RoundBox(pos+vec3(0.,0.,25.),vec3(25.5,25.,.3),0.)-noise*.2,12.,pos);return SmoothUnion(O(dist,11.,pos),bg,0.5);}O map(vec3 pos){if(phase<1.){return mapFumes2(pos);}else if(phase<2.){return mapFumes3(pos);}else if(phase<3.){return mapFumes4(pos);}else if(phase<4.){return mapFumes(pos);}return mapExhibition(pos);}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=30.;MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){if(res.mat<11.5){volumetric+=${color1}*VOLUMETRIC_STEP*volumetricStepMultiplier;}if(res.mat<12.5){volumetric+=${color5}*VOLUMETRIC_STEP;}}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 light=vec3(sin(time*0.15)*7.,4.5+sin(time*0.14)*1.5,sin(time*0.05)*7.);float ambience=0.75;if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 fr=fract(result.worldPosition-result.O.pos);float xid=step(fr.x,0.5);float yid=step(fr.y,0.5);float zid=step(fr.z,0.5);float id=xid+yid+zid;vec3 color=mix(${color2},${color3},id<0.5?0.:id<1.5?1.:0.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=${color5};col=color*(ambience+Diffuse(p,light,normal));}else if(result.O.mat<2.5){vec3 color=${color2};col=color*(ambience+Diffuse(p,light,normal));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/100.;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST-25.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float fov;uniform vec3 camera;uniform vec3 target;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform vec3 cuberot;uniform vec3 cubepos;uniform float ambience;uniform float torus1size;uniform float torus2size;uniform float torus3size;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float Torus(vec3 pos,vec2 t){vec2 q=vec2(length(pos.xz)-t.x,pos.y);return length(q)-t.y;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float Sphere(vec3 pos,float radius){return length(pos)-radius;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=30.;vec3 volumetric=vec3(0.);float gyroid_3(vec3 seed){return dot(cos(seed),sin(seed.zxy));}float fbm_3(vec3 p){float t=0.;float a=.5;for(int i=0;i<12;++i){p.z-=(time*0.+t*.3);p.y-=time*0.+t*.3;t+=abs(gyroid_3(p/a))*a;a*=.5;}return t;}vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}O map(vec3 pos){vec3 cubePos=(pos+cubepos);O cube=O(Torus(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec2(0.95*torus1size,0.15)),1.,vec3(0.,0.9,0.));O cube2=O(Torus(cubePos*Rot(cuberot.x*1.25,cuberot.y*1.25,cuberot.z*1.25),vec2(0.95*torus2size,0.15)),1.,vec3(0.,0.9,0.));O cube3=O(Torus(cubePos*Rot(cuberot.x,cuberot.y,cuberot.z*1.1),vec2(0.95*torus3size,0.15)),1.,vec3(0.,0.9,0.));cube=Union(cube,cube2);cube=Union(cube,cube3);O ground1=O(Ground(pos,-2.),0.,pos);O ground2=O(Ground(pos.yxz,-2.),0.15,pos);O ground3=O(Ground(pos.xzy,-2.),0.25,pos);O result=Union(ground1,ground2);result=Union(result,ground2);result=Union(result,ground3);result=Union(result,cube);vec3 seed=pos;seed.z-=time;seed.y+=time;if(result.mat>=9.5){float noise=fbm_3(seed*.5);result.dist-=noise*.2;}return result;}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){volumetric+=${color1}*VOLUMETRIC_STEP;}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 fr=fract(result.worldPosition.xyz);float id=result.O.mat<0.1?length(fr.x-0.5)+length(fr.z-0.5):result.O.mat<0.2?length(fr.z-0.5)+length(fr.y-0.5):length(fr.x-0.5)+length(fr.y-0.5);vec3 color=mix(${color2},${color3},smoothstep(0.49,0.5,id));col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));vec3 refCol=vec3(0.);vec3 refRd=reflect(rayDir,normal);MarchResult reflectMarch=raymarch(p+normal*STEP_LOW,refRd);if(reflectMarch.O.mat<-0.5){}else if(reflectMarch.O.mat<0.5){}else if(reflectMarch.O.mat<1.5){vec3 rp=reflectMarch.worldPosition;vec3 rnormal=reflectMarch.normal;vec3 color=${color1};refCol=color*(ambience+0.5*Diffuse(rp,light1,rnormal));}MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));col=mix(refCol,col,0.20);col*=0.5+0.5*smoothstep(0.,0.1,shadowMarch.worldPosition.x);}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=vec3(1.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/MAXDIST;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST*3./4.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float fov;uniform vec3 camera;uniform vec3 target;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform vec3 cuberot;uniform vec3 cubepos;uniform float ambience;uniform vec3 slider1;uniform vec3 slider2;uniform vec3 slider3;uniform vec3 slider4;uniform vec3 slider5;uniform vec3 slider6;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float Torus(vec3 pos,vec2 t){vec2 q=vec2(length(pos.xz)-t.x,pos.y);return length(q)-t.y;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float Sphere(vec3 pos,float radius){return length(pos)-radius;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=50.;vec3 volumetric=vec3(0.);float gyroid_3(vec3 seed){return dot(cos(seed),sin(seed.zxy));}float fbm_3(vec3 p){float t=0.;float a=.5;for(int i=0;i<12;++i){p.z-=(time*0.+t*.3);p.y-=time*0.+t*.3;t+=abs(gyroid_3(p/a))*a;a*=.5;}return t;}vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}O cubed(vec3 pos,vec3 slide1,vec3 slide2,vec3 slide3,vec3 slide4,vec3 slide5,vec3 slide6){vec3 cubePos=(pos+cubepos+slide1);O cube=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos);vec3 off=vec3(1.,0.,0.);cubePos=(pos+cubepos+off+slide2);O cube2=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos+off);off=vec3(1.,-1.,0.);cubePos=(pos+cubepos+off+slide3);O cube3=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos+off);off=vec3(0.,-1.,1.);cubePos=(pos+cubepos+off+slide4);O cube4=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos+off);off=vec3(1.,-1.,1.);cubePos=(pos+cubepos+off+slide5);O cube5=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos+off);off=vec3(0.,-0.,1.);cubePos=(pos+cubepos+off+slide6);O cube6=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.5),0.),0.,cubepos+off);cube=Union(cube,cube2);cube=Union(cube,cube3);cube=Union(cube,cube4);cube=Union(cube,cube5);cube=Union(cube,cube6);return cube;}O cubed2(vec3 pos,vec3 slide1,vec3 slide2,vec3 slide3,vec3 slide4,vec3 slide5,vec3 slide6){vec3 cubePos=(pos+cubepos+slide1);O cube=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.25,cubepos-vec3(-0.25,-0.75,-0.25)-slide1);vec3 off=vec3(1.,0.,0.)*0.5;cubePos=(pos+cubepos+off+slide2);O cube2=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.35,cubepos+off-vec3(-0.25,-0.75,-0.25)-slide2);off=vec3(1.,-1.,0.)*0.5;cubePos=(pos+cubepos+off+slide3);O cube3=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.25,cubepos+off-vec3(-0.25,-0.75,-0.25)-slide3);off=vec3(0.,-1.,1.)*0.5;cubePos=(pos+cubepos+off+slide4);O cube4=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.25,cubepos+off-vec3(-0.25,-0.75,-0.25)-slide4);off=vec3(1.,-1.,1.)*0.5;cubePos=(pos+cubepos+off+slide5);O cube5=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.35,cubepos+off-vec3(-0.25,-0.75,-0.25)-slide5);off=vec3(0.,-0.,1.)*0.5;cubePos=(pos+cubepos+off+slide6);O cube6=O(RoundBox(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),vec3(0.25),0.),0.35,cubepos+off-vec3(-0.25,-0.75,-0.25)-slide6);cube=Union(cube,cube2);cube=Union(cube,cube3);cube=Union(cube,cube4);cube=Union(cube,cube5);cube=Union(cube,cube6);return cube;}O map(vec3 pos){O cube=cubed(pos,vec3(0.),vec3(0.),vec3(0.),vec3(0.),vec3(0.),vec3(0.));O cube2=cubed2(pos+vec3(-0.25,-0.75,-0.25),slider1,slider2,slider3,slider4,slider5,slider6);cube=Union(cube,cube2);return cube;}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist*0.75:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){volumetric+=vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 fr=fract(result.worldPosition-result.O.pos);float xid=step(fr.x,0.5);float yid=step(fr.y,0.5);float zid=step(fr.z,0.5);float id=xid+yid+zid;if(result.O.mat>0.2){fr=fract(result.worldPosition-result.O.pos);xid=step(fr.x,0.25);yid=step(fr.y,0.25);zid=step(fr.z,0.25);id=xid+yid+zid;}vec3 color=mix(${color2},${color3},id<0.5?0.:id<1.5?1.:0.);col=color;col=color*(ambience+0.5+${color1}*Diffuse(p,light1,normal));vec3 refCol=vec3(0.);vec3 refRd=reflect(rayDir,normal);MarchResult reflectMarch=raymarch(p+normal*STEP_LOW,refRd);if(reflectMarch.O.mat<-0.5){}else if(reflectMarch.O.mat<0.5){}else if(reflectMarch.O.mat<1.5){vec3 rp=reflectMarch.worldPosition;vec3 rnormal=reflectMarch.normal;vec3 color=${color1};refCol=color*(ambience+0.5*Diffuse(rp,light1,rnormal));}MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));col=mix(refCol,col,0.20);col*=0.5+0.5*smoothstep(0.,0.1,shadowMarch.worldPosition.x);col*=3.;}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=vec3(1.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/MAXDIST;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST*3./4.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float fov;uniform vec3 camera;uniform vec3 target;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform vec3 cuberot;uniform vec3 cubepos;uniform float ambience;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float Torus(vec3 pos,vec2 t){vec2 q=vec2(length(pos.xz)-t.x,pos.y);return length(q)-t.y;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float Sphere(vec3 pos,float radius){return length(pos)-radius;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=30.;vec3 volumetric=vec3(0.);vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}O map(vec3 pos){vec3 cubePos=(pos+cubepos);O cube=O(Sphere(cubePos*Rot(cuberot.x*1.5,cuberot.y*1.5,cuberot.z*1.5),0.5),1.,vec3(0.,0.9,0.));O ground1=O(Ground(pos,-1.),0.,pos);O ground2=O(Ground(pos.yxz,-40.),0.15,pos);O ground3=O(Ground(pos.xzy,-2.),0.25,pos);O result=Union(ground1,ground2);result=Union(result,ground2);result=Union(result,ground3);result=Union(result,cube);return result;}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){volumetric+=vec3(10.9,10.6,10.55)*VOLUMETRIC_STEP;}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 fr=fract(result.worldPosition.xyz);float id=result.O.mat<0.1?length(fr.x-0.5)+length(fr.z-0.5):result.O.mat<0.2?length(fr.z-0.5)+length(fr.y-0.5):length(fr.x-0.5)+length(fr.y-0.5);vec3 color=mix(${color2},${color3},smoothstep(0.49,0.5,id));col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));vec3 refCol=vec3(0.);vec3 refRd=reflect(rayDir,normal);MarchResult reflectMarch=raymarch(p+normal*STEP_LOW,refRd);if(reflectMarch.O.mat<-0.5){}else if(reflectMarch.O.mat<0.5){}else if(reflectMarch.O.mat<1.5){vec3 rp=reflectMarch.worldPosition;vec3 rnormal=reflectMarch.normal;vec3 color=${color1};refCol=color*(ambience+0.5*Diffuse(rp,light1,rnormal));}MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));col=mix(refCol,col,0.20);col*=0.5+0.5*smoothstep(0.,0.1,shadowMarch.worldPosition.x);}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=vec3(1.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));MarchResult shadowMarch=raymarchLow(p+normal*STEP_LOW,normalize(light1-p),distance(light1,p));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/MAXDIST;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST*3./4.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform vec3 camera;uniform vec3 target;uniform float fov;uniform vec4 hammerRotation;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform float phase;uniform float noiseMultiplier;uniform vec3 offset;const float PI2=6.28318530717;const float PI=3.14159265359;const float PHI=1.61803398874;struct O{float dist;float mat;vec3 pos;};struct MarchResult{O O;int steps;vec3 worldPosition;vec3 normal;float travel;};vec3 RotPointX(vec3 p,float d){mat4 rotM=mat4(1.,0.,0.,0.,0.,cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointY(vec3 p,float d){mat4 rotM=mat4(cos(d),0.,sin(d),0.,0.,1.,0.,0.,-sin(d),0.,cos(d),0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}vec3 RotPointZ(vec3 p,float d){mat4 rotM=mat4(cos(d),-sin(d),0.,0.,sin(d),cos(d),0.,0.,0.,0.,1.,0.,0.,0.,0.,1.);return vec3(rotM*vec4(p,1.));}mat3 RotX(float a){return mat3(1.,0.,0.,0.,cos(a),-sin(a),0.,sin(a),cos(a));}mat3 RotY(float a){return mat3(cos(a),0.,sin(a),0.,1.,0.,-sin(a),0.,cos(a));}mat3 RotZ(float a){return mat3(cos(a),-sin(a),0.,sin(a),cos(a),0.,0.,0.,1.);}mat3 Rot(float x,float y,float z){return RotX(x)*RotY(y)*RotZ(z);}mat2 Rot2D(float a){return mat2(cos(a),-sin(a),sin(a),cos(a));}vec2 Rot2DPoint(vec2 p,float a){return Rot2D(a)*p;}float HexPrism(vec3 p,vec2 h){const vec3 k=vec3(-0.8660254,0.5,0.57735);p=abs(p);p.xy-=2.*min(dot(k.xy,p.xy),0.)*k.xy;vec2 d=vec2(length(p.xy-vec2(clamp(p.x,-k.z*h.x,k.z*h.x),h.x))*sign(p.y-h.x),p.z-h.y);return min(max(d.x,d.y),0.)+length(max(d,0.));}float Ground(vec3 position,float height){return position.y-height;}float RoundBox(vec3 p,vec3 b,float r){vec3 d=abs(p)-b;return min(max(d.x,max(d.y,d.z)),0.)+length(max(d,0.))-r;}float BoxFrame(vec3 p,vec3 b,float e){p=abs(p)-b;vec3 q=abs(p+e)-e;return min(min(length(max(vec3(p.x,q.y,q.z),0.))+min(max(p.x,max(q.y,q.z)),0.),length(max(vec3(q.x,p.y,q.z),0.))+min(max(q.x,max(p.y,q.z)),0.)),length(max(vec3(q.x,q.y,p.z),0.))+min(max(q.x,max(q.y,p.z)),0.));}float Sphere(vec3 pos,float radius){return length(pos)-radius;}float Octahedron(vec3 p,float s){p=abs(p);return(p.x+p.y+p.z-s)*0.57735027;}float Torus(vec3 pos,vec2 t){vec2 q=vec2(length(pos.xz)-t.x,pos.y);return length(q)-t.y;}O Union(O a,O b){float s=step(b.dist,a.dist);return O(mix(a.dist,b.dist,s),mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}O SmoothUnion(O a,O b,float k){float h=clamp(0.5+0.5*(b.dist-a.dist)/k,0.,1.);float dist=mix(b.dist,a.dist,h)-k*h*(1.-h);float s=step(b.dist,a.dist);return O(dist,mix(a.mat,b.mat,s),mix(a.pos,b.pos,s));}vec3 Repeat(vec3 p,vec3 c){vec3 q=vec3(0.);vec3 q2=mod(p+0.5*c,c)-0.5*c;q.x=c.x>0.?q2.x:p.x;q.y=c.y>0.?q2.y:p.y;q.z=c.z>0.?q2.z:p.z;return q;}float Subtraction(float a,float b){return max(-b,a);}\n#define A .1031\nfloat Hash(float p){vec3 p3=fract(vec3(p)*A);p3+=dot(p3,p3.yzx+19.19);return fract((p3.x+p3.y)*p3.z);}vec3 volumetric=vec3(0.);vec3 getCameraRayDir(vec2 uv,vec3 pos,vec3 target,float fov){vec3 forward=normalize(target-pos);vec3 right=normalize(cross(vec3(0.,1.,0.),forward));vec3 up=normalize(cross(forward,right));return normalize(uv.x*right+uv.y*up+forward*fov);}float gyroid_3(vec3 seed){return dot(cos(seed),sin(seed.zxy));}float fbm_3(vec3 p){float t=0.;float a=.5;for(int i=0;i<12;++i){p.z-=(time*0.+t*.3);p.y-=time*0.+t*.3;t+=abs(gyroid_3(p/a))*a;a*=.5;}return t;}O mapBelt(vec3 pos){vec3 id=floor(pos+offset);vec3 opos=Repeat(pos*Rot(id.x,id.y,id.z),vec3(0.25,0.,0.25));float o=Octahedron(opos,0.45);pos=Repeat(pos,vec3(1.));float s=Sphere(pos,1.5);s=max(o,s);O S=O(s,4.,pos);return S;}O mapFumes(vec3 pos){vec3 seed=pos;seed.z-=time;seed.y+=time;float noise=fbm_3(seed*.5);O fumes=mapBelt(pos+vec3(0.,-1.5,1.5));fumes.dist-=noise*noiseMultiplier;fumes.mat=11.;return fumes;}O map(vec3 pos){return mapFumes(pos);}vec3 RandomSphereDir(vec2 rnd){float s=rnd.x*PI*2.;float t=rnd.y*2.-1.;return vec3(sin(s),cos(s),t)/sqrt(1.+t*t);}vec3 RandomHemisphereDir(vec3 dir,float i){vec3 v=RandomSphereDir(vec2(Hash(i+1.),Hash(i+2.)));return v*sign(dot(v,dir));}float AmbientOcclusion(in vec3 p,in vec3 n,in float maxDist,in float falloff){const int nbIte=32;const float nbIteInv=1./float(nbIte);const float rad=1.-1.*nbIteInv;float ao=0.;for(int i=0;i<nbIte;i++){float l=Hash(float(i))*maxDist;vec3 rd=normalize(n+RandomHemisphereDir(n,l)*rad)*l;ao+=(l-max(map(p+rd).dist,0.))/maxDist*falloff;}return clamp(1.-ao*nbIteInv,0.,1.);}vec3 CalcNormal(vec3 pos){float c=map(pos).dist;vec2 e=vec2(0.001,0.);return normalize(vec3(map(pos+e.xyy).dist,map(pos+e.yxy).dist,map(pos+e.yyx).dist)-c);}vec3 Diffuse(vec3 pos,vec3 light,vec3 normal){float dotNL=max(dot(normal,normalize(light-pos)),0.);return vec3(1.)*dotNL;}const float STEP=0.001;const float VOLUMETRIC_STEP=0.01;const float MAXDIST=30.;MarchResult raymarch(vec3 cam,vec3 rd){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);for(int i=0;i<256;i++){p=cam+rd*t;res=map(p);t+=res.mat<10.?res.dist:max(VOLUMETRIC_STEP,res.dist-VOLUMETRIC_STEP);if(res.mat>=10.&&res.dist<VOLUMETRIC_STEP){if(res.mat<11.5){volumetric+=${color1}*VOLUMETRIC_STEP;}if(res.mat<12.5){volumetric+=${color5}*VOLUMETRIC_STEP;}}else if(res.dist<STEP){break;}if(t>MAXDIST){res.mat=-1.;t=MAXDIST;break;}steps++;}MarchResult mr=MarchResult(res,steps,p,vec3(0),t);if(res.mat>-0.5&&res.mat<9.5){mr.normal=CalcNormal(mr.worldPosition);}return mr;}const float STEP_LOW=0.01;MarchResult raymarchLow(vec3 cam,vec3 rd,float maxdist){float t=0.;vec3 col=vec3(0.);O res;int steps=0;vec3 p=vec3(0.);float minval=1.;for(int i=0;i<512;i++){p=cam+rd*t;res=map(p);t+=max(STEP_LOW,res.dist);if(res.mat<9.5&&res.mat>0.5){minval=min(minval,res.dist);}if(res.dist<STEP_LOW&&res.mat<9.5&&res.mat>0.5){break;}if(t>maxdist){res.mat=-1.;t=maxdist;break;}steps++;}if(steps>=512)res.mat=-1.;p.x=minval;MarchResult mr=MarchResult(res,steps,p,vec3(0),t);return mr;}void colorize(MarchResult result,vec3 rayDir,out vec3 col){col=vec3(0.);vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 light=vec3(sin(time*0.15)*7.,4.5+sin(time*0.14)*1.5,sin(time*0.05)*7.);float ambience=0.75;if(result.O.mat<-0.5){}else if(result.O.mat<0.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 fr=fract(result.worldPosition-result.O.pos);float xid=step(fr.x,0.5);float yid=step(fr.y,0.5);float zid=step(fr.z,0.5);float id=xid+yid+zid;vec3 color=mix(${color2},${color3},id<0.5?0.:id<1.5?1.:0.);col=color*(ambience+${color1}*Diffuse(p,light1,normal)+${color2}*Diffuse(p,light2,normal)+${color3}*Diffuse(p,light3,normal));}else if(result.O.mat<1.5){vec3 p=result.worldPosition;vec3 normal=result.normal;vec3 color=${color5};col=color*(ambience+Diffuse(p,light,normal));}else if(result.O.mat<2.5){vec3 color=${color2};col=color*(ambience+Diffuse(p,light,normal));}}void render(vec2 uv,out vec4 diffuse){vec3 rd=getCameraRayDir(uv,camera,target,fov);MarchResult result=raymarch(camera,rd);colorize(result,rd,diffuse.rgb);diffuse.a=result.travel/100.;diffuse.rgb=mix(diffuse.rgb,vec3(0),smoothstep(MAXDIST-25.,MAXDIST,result.travel));}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);render(uv,col);return col+vec4(volumetric/(1.+AA),0.);}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float inkdropSize;uniform float logoPhase;uniform sampler2D logo;float distanceToPoint(vec2 position,vec2 point){return sqrt(pow(position.x-point.x,2.)+pow(position.y-point.y,2.));}mat2 Rot2D(float a){return mat2(cos(a),-sin(a),sin(a),cos(a));}vec2 Rot2DPoint(vec2 p,float a){return Rot2D(a)*p;}void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;float speed=.5;float scale=0.003;vec2 p=gl_FragCoord.xy*scale;for(int i=1;i<5;i++){p.x+=0.3/float(i)*sin(float(i)*4.*p.y+time*speed);p.y+=0.3/float(i)*cos(float(i)*4.*p.x+time*speed);}float r=cos(sin(p.x)-sin(p.y)+time*speed*2.);float g=sin(cos(p.x)+cos(p.y)-time*speed*2.);float b=(sin(cos(p.x)*cos(p.y)+time*speed*2.)-cos(sin(p.x)*sin(p.y)+time*speed*2.));vec3 color=mix(${color1},${color3},abs(r+g+b));outColor=vec4(clamp(vec3(0.),vec3(1.),color/3.),1);vec4 l=texture(logo,(gl_FragCoord.xy/resolution.xy)+sin(outColor.xy*50.+time*0.1)*0.001);vec4 logoCol=outColor*smoothstep(0.,0.1,(logoPhase-l.r/l.a*0.9)*1.1)*l.r*l.a;outColor=mix(logoCol+outColor,logoCol,clamp(1.-inkdropSize,0.,1.));outColor.a=1.;}"},e=>{e.exports="#version 300 es\nprecision highp float;layout(location=0)out vec4 outColor;uniform vec2 resolution;uniform float time;uniform float fov;uniform vec3 camera;uniform vec3 target;uniform vec3 light1;uniform vec3 light2;uniform vec3 light3;uniform float ambience;uniform vec3 repeat;float sdBox(vec3 p,vec3 b){vec3 q=abs(p)-b;return length(max(q,0.))+min(max(q.x,max(q.y,q.z)),0.);}void rot(inout vec2 p,float a){p=cos(a)*p+sin(a)*vec2(p.y,-p.x);}vec2 opU(vec2 d1,vec2 d2){return(d1.x<d2.x)?d1:d2;}vec3 Repeat(vec3 p,vec3 q){return mod(p+0.5*q,q)-q*0.5;}float llength=.4;float lspread=.4;float wspeedmod=4.;float wstridemod=.2;struct MarchResult{vec3 p;float id;};vec2 sdf(vec3 p){vec3 pp=p;pp=pp-vec3(1.+sin(time*wspeedmod*2.)*.02,.7,0.);float head=sdBox(pp,vec3(.5,.4,.5));vec3 ppp=pp-vec3(.7,-.1,0.);float beak=sdBox(ppp,vec3(.2,0.08,.2));pp.z=abs(pp.z);pp=pp-vec3(.5,.2,.3);float eyes=sdBox(pp,vec3(.1,.1,.1));vec2 h=opU(vec2(eyes,1.),opU(vec2(beak,2.),vec2(head,3.)));pp=p;rot(pp.xz,-sin(time*wspeedmod)*.1);float body=sdBox(pp,vec3(1.,.6,.8));pp=pp-vec3(-1.1+sin(time*wspeedmod*2.)*0.02,.7,0.);rot(pp.xz,sin(time*wspeedmod)*.1);float tail=sdBox(pp,vec3(.4,.1,.6));body=min(tail,body);vec2 b=opU(vec2(body,3.),h);pp=p;rot(pp.xy,sin(time*wspeedmod)*wstridemod);pp=pp-vec3(0.,-1.,lspread);float lleg=sdBox(pp,vec3(.1,llength,.2));lleg=min(lleg,sdBox(pp-vec3(.2,-llength,0.),vec3(.4,.1,.2)));pp=p;rot(pp.xy,-sin(time*wspeedmod)*wstridemod);pp=pp-vec3(0.,-1.,-lspread);float rleg=sdBox(pp,vec3(.1,llength,.2));rleg=min(rleg,sdBox(pp-vec3(.2,-llength,0.),vec3(.4,.1,.2)));float legs=min(lleg,rleg);return opU(vec2(p.y+1.7,10.),opU(vec2(legs,2.),b));}MarchResult march(in vec3 ro,in vec3 rd,inout float t){MarchResult m;m.p=ro+rd;for(int i=0;i<40;++i){vec2 d=sdf(m.p);t+=d.x*0.5;m.p+=rd*d.x;m.id=d.y;if(d.x<0.01||t>100.){break;}}return m;}vec3 color(in float id,in vec3 p){vec3 c=vec3(0.);if(id==1.)c=${color1};else if(id==2.)c=${color2};else if(id==3.)c=${color3};else if(id>=5.){vec2 id=fract(p.xz*0.25+vec2(time*0.150,0.));float i=length(id.x-0.5)+length(id.y-0.5);c=mix(${color4},${color5},smoothstep(0.49,0.5,i));}return c;}vec3 calcNormal(in vec3 pos){vec2 e=vec2(0.00001,0.);return normalize(vec3(sdf(pos+e.xyy).x-sdf(pos-e.xyy).x,sdf(pos+e.yxy).x-sdf(pos-e.yxy).x,sdf(pos+e.yyx).x-sdf(pos-e.yyx).x));}void mainImage_(vec2 uv,out vec4 fragColor){vec2 q=uv;vec3 cp=camera;vec3 ct=vec3(0,0,0);vec3 ld=vec3(-2.,0.5,2.);vec3 cf=normalize(ct-cp);vec3 cr=normalize(cross(vec3(0.,1.,0.),cf));vec3 cu=normalize(cross(cf,cr));vec3 rd=normalize(mat3(cr,cu,cf)*vec3(q,radians(90.)));vec3 p=vec3(0.);float t;MarchResult m;m.p=vec3(0.);m.id=0.;m=march(cp,rd,t);vec3 col=vec3(0.);if(t<100.){col=color(m.id,m.p)+(clamp(dot(calcNormal(m.p),ld),0.,1.)*0.1);}col=mix(col,${color5},smoothstep(10.,15.,t));fragColor=vec4(col,1.);}vec4 Main(vec2 uv,float AA){vec4 emissive=vec4(0.);vec4 col=vec4(0.);mainImage_(uv,col);return col;}float AA=${AA-LEVEL};void main(){vec2 uv=(gl_FragCoord.xy/resolution.xy-0.5)*2.;uv.y*=resolution.y/resolution.x;vec4 col=Main(uv,AA);float count=1.;vec2 aaStep=vec2(1./AA)/resolution.xy;for(float aaX=0.;aaX<AA;aaX++){for(float aaY=0.;aaY<AA;aaY++){col+=Main(uv+vec2(aaX,aaY)*aaStep,AA);count++;}}col/=count;outColor=col;}"},e=>{e.exports="#version 300 es\nprecision highp float;uniform sampler2D texture;uniform float exposure;uniform float brightness;uniform float contrast;out vec4 outColor;void main(){vec4 c=texelFetch(texture,ivec2(gl_FragCoord.xy),0);c.rgb=vec3(1.)-exp(-c.rgb*exposure);c.rgb*=contrast;c.rgb+=vec3(brightness);c.rgb=max(vec3(0.),c.rgb);outColor=c;}"}],t={};function i(s){var o=t[s];if(void 0!==o)return o.exports;var r=t[s]={exports:{}};return e[s](r,r.exports,i),r.exports}i.n=e=>{var t=e&&e.__esModule?()=>e.default:()=>e;return i.d(t,{a:t}),t},i.d=(e,t)=>{for(var s in t)i.o(t,s)&&!i.o(e,s)&&Object.defineProperty(e,s,{enumerable:1,get:t[s]})},i.o=(e,t)=>Object.prototype.hasOwnProperty.call(e,t),(()=>{"use strict";class e{constructor(){this.callbacks=[]}connect(e){this.callbacks.push(e)}disconnect(e){let t=this.callbacks.indexOf(e);t>=0&&this.callbacks.splice(t,1)}emit(e){this.callbacks.forEach((t=>t(e)))}}class t{static hexToArray(e){return[(e>>16&255)/255,(e>>8&255)/255,(255&e)/255]}static cross(e,t){return[e[1]*t[2]-e[2]*t[1],e[2]*t[0]-e[0]*t[2],e[0]*t[1]-e[1]*t[0]]}static normalize(e){let t=[],i=0;for(let t=0;t<e.length;t++)i+=e[t]*e[t];let s=Math.sqrt(i);for(let i=0;i<e.length;i++)t.push(e[i]/s);return t}static smoothstep(e,t,i){return(i=this.clamp(0,1,(i-e)/(t-e)))*i*(3-2*i)}static clamp(e,t,i){return Math.min(t,Math.max(e,i))}static lerp(e,t,i){return(1-i)*e+i*t}static lerpList(e,i,s,o=[]){if(e.length!=i.length)return e;for(let r=0;r<e.length;r++)o[r]=t.lerp(e[r],i[r],s);return o}static lpad(e,t,i="0"){let s=e.toString();for(;s.length<t;)s=i+s;return s}}const s={range:16/9,string:"16:9"},o=[{string:"240p",resolution:240},{string:"720p",resolution:720},{string:"1080p",resolution:1080,default:1},{string:"fit screen",resolution:-1}];class r{constructor(){this.shaderConstants={},this.precision=1024,this.title="",this.beatsPerBar=4,this.ticksPerBeat=16,this.beatsPerMinute=120,this.aspectRatio=s,this.resolutions=o,this.music="music.ogg",this.debug=1,this.looping=0,this.muted=0,this.parts=[],this.images=[],this.enableKHRParallelCompilation=1,this.generateFFT=1,this.debugUniformSliders=this.debug,this.analyserVersion="modern"}}const a=e=>new p(e[0],e[1],e[2],h.ABSOLUTE);let n=new r;function c(){return n}new e;const l=(e,t)=>{const i=e.split(".");let s=window;for(let e=0;e<i.length-1;e++)if(Reflect.has(s,i[e]))s=Reflect.get(s,i[e]);else{const t={};Reflect.set(s,i[e],t),s=t}Reflect.set(s,i[i.length-1],t)};var h,u,d;!function(e){e[e.RELATIVE=0]="RELATIVE",e[e.ABSOLUTE=1]="ABSOLUTE",e[e.PATTERN=2]="PATTERN"}(h||(h={}));class p{constructor(e=0,t=0,i=0,s=h.ABSOLUTE){this.bar=0,this.beat=0,this.tick=0,this.delta=0,this.bar=e,this.beat=t,this.tick=i,this.pattern=s}matchesPattern(e,t){return this.pattern==h.ABSOLUTE?this.equals(e):this.pattern==h.RELATIVE?e.bar==t.bar+this.bar&&e.beat==t.beat+this.beat&&e.tick==t.tick+this.tick:this.pattern==h.PATTERN?!(-1!=this.bar&&e.bar%this.bar!=0||-1!=this.beat&&e.beat%c().beatsPerBar!=this.beat||-1!=this.tick&&e.tick%c().ticksPerBeat!=this.tick):0}add(e){return this.addBars(e.bar),this.addBeats(e.beat),this.addTicks(e.tick),this}addBars(e){return this.bar+=e,this}addBeats(e){return this.beat+=e,this.bar+=Math.floor(this.beat/c().beatsPerBar),this.beat%=c().beatsPerBar,this}addTicks(e){for(this.tick+=e;this.tick>=c().ticksPerBeat;)this.tick-=c().ticksPerBeat,this.beat++;for(;this.beat>=c().beatsPerBar;)this.beat-=c().beatsPerBar,this.bar++;return this}subtract(e){return this.subtractBars(e.bar),this.subtractBeats(e.beat),this.subtractTicks(e.tick),this}subtractBars(e){return this.bar-=e,this}subtractBeats(e){for(this.beat-=e;this.beat<0;)this.bar--,this.beat+=c().beatsPerBar;return this}subtractTicks(e){for(this.tick-=e;this.tick<0;)this.tick+=c().ticksPerBeat,this.beat--;for(;this.beat<0;)this.bar--,this.beat+=c().beatsPerBar;return this}fromTime(e){var t=c().beatsPerMinute*e;return this.bar=Math.floor(t/c().beatsPerBar),this.beat=Math.floor(t%c().beatsPerBar),this.tick=Math.floor((t-Math.floor(t))*c().ticksPerBeat),this}static create(e){return(new p).fromTime(e)}isInside(e,t,i){return i?this.isSmallerThan(t.clone().add(i))&&this.isLargerThan(e.clone().add(i)):this.isSmallerThan(t)&&this.isLargerThan(e)}isSmallerThan(e){var t=this.bar*c().beatsPerBar*c().ticksPerBeat+this.beat*c().ticksPerBeat+this.tick,i=e.bar*c().beatsPerBar*c().ticksPerBeat+e.beat*c().ticksPerBeat+e.tick;return t<i||t==i}isLargerThan(e){var t=this.bar*c().beatsPerBar*c().ticksPerBeat+this.beat*c().ticksPerBeat+this.tick,i=e.bar*c().beatsPerBar*c().ticksPerBeat+e.beat*c().ticksPerBeat+e.tick;return t>i||t==i}toMilliseconds(){c().beatsPerMinute,c().ticksPerBeat;return 60*(this.bar*c().beatsPerBar/c().beatsPerMinute+this.beat/c().beatsPerMinute+this.tick/c().ticksPerBeat/c().beatsPerMinute)*1e3}equals(e){return this.bar*c().beatsPerBar*c().ticksPerBeat+this.beat*c().ticksPerBeat+this.tick==e.bar*c().beatsPerBar*c().ticksPerBeat+e.beat*c().ticksPerBeat+e.tick}clone(){return new p(this.bar,this.beat,this.tick,this.pattern)}toString(e=1){return`${t.lpad(this.bar,3)}:${t.lpad(this.beat,2)}:${t.lpad(this.tick,2)}${e?" ["+h[this.pattern]+"]":""}`}static toMilliseconds(e=0,t=0,i=0){return 60*(e*c().beatsPerBar/c().beatsPerMinute+t/c().beatsPerMinute+i/c().ticksPerBeat/c().beatsPerMinute)*1e3}}p.zero=()=>new p,l("kvg.Timesig",p),function(e){e[e.UnInitialized=0]="UnInitialized",e[e.Initializing=1]="Initializing",e[e.Loading=2]="Loading",e[e.Ready=3]="Ready",e[e.Running=4]="Running",e[e.Paused=5]="Paused",e[e.Stopped=6]="Stopped"}(u||(u={}));class m{static INIT(){this.state=u.Initializing,m.onMusicLoaded=new e,m.context=new AudioContext,m.analyserLeft=m.context.createAnalyser(),m.analyserRight=m.context.createAnalyser(),m.scriptNode=m.context.createScriptProcessor(m.PRECISION,1,1),m.gainNode=m.context.createGain(),m.splitNode=m.context.createChannelSplitter(2),m.mergeNode=m.context.createChannelMerger(2),m.gainNode.connect(m.context.destination),m.splitNode.connect(m.analyserLeft,0,0),m.splitNode.connect(m.analyserRight,1,0),m.analyserLeft.connect(m.mergeNode,0,0),m.analyserRight.connect(m.mergeNode,0,1),m.mergeNode.connect(m.gainNode),m.fft={fftsize:m.PRECISION,sampleRate:m.context.sampleRate,dbLeft:new Float32Array(m.analyserLeft.frequencyBinCount),frequencyLeft:new Uint8Array(m.analyserLeft.frequencyBinCount),waveformLeft:new Uint8Array(m.analyserLeft.frequencyBinCount),dbRight:new Float32Array(m.analyserLeft.frequencyBinCount),frequencyRight:new Uint8Array(m.analyserLeft.frequencyBinCount),waveformRight:new Uint8Array(m.analyserLeft.frequencyBinCount)}}static reset(){this.createSourceNode()}static adjustSpeed(e){if(m.sourceNode){const t=m.sourceNode.playbackRate.value,i=m.position();m.elapsedWithPreviousPlaybackRate=m.position(),m.sourceNode.playbackRate.value=e,m.started=m.context.currentTime,e>=0&&t<0&&m.gotoPosition(1e3*i)}}static createSourceNode(e){var t;let i=null;(null===(t=m.sourceNode)||void 0===t?void 0:t.buffer)&&(i=m.sourceNode.buffer),m.sourceNode=m.context.createBufferSource(),m.sourceNode.onended=()=>{m.ended=1},m.sourceNode.connect(m.splitNode),m.sourceNode.buffer=e||i}static updateFFT(){m.analyserLeft.getFloatFrequencyData(m.fft.dbLeft),m.analyserLeft.getByteFrequencyData(m.fft.frequencyLeft),m.analyserLeft.getByteTimeDomainData(m.fft.waveformLeft),m.analyserRight.getFloatFrequencyData(m.fft.dbRight),m.analyserRight.getByteFrequencyData(m.fft.frequencyRight),m.analyserRight.getByteTimeDomainData(m.fft.waveformRight)}static loadMusic(e){this.state=u.Loading;let t=new XMLHttpRequest;t.open("GET",e,1),t.responseType="arraybuffer",t.onload=()=>{m.context.decodeAudioData(t.response,(e=>{this.createSourceNode(e),m.duration=e.duration,this.onMusicLoaded.emit(null),this.state=u.Ready}),(e=>{this.onMusicLoaded.emit(null)}))},t.ontimeout=e=>{this.onMusicLoaded.emit(null)},t.onerror=e=>{this.onMusicLoaded.emit(null)},t.send()}static start(){m.ended=0,m.gainNode.gain.setValueAtTime(c().muted?0:1,0),this.state=u.Running,m.started=m.context.currentTime,m.sourceNode.start(0)}static stop(){this.state=u.Stopped,m.sourceNode.stop(0)}static pause(){this.state==u.Running&&(m.pausedAt=m.context.currentTime-m.started,m.context.suspend(),this.state=u.Paused)}static play(){this.state==u.Paused&&this.pausedAt>0&&(m.context.resume(),this.state=u.Running)}static pauseOrResume(){this.state==u.Paused?this.play():this.pause()}static position(){return m.sourceNode.playbackRate.value*(m.context.currentTime-m.started)+m.elapsedWithPreviousPlaybackRate}static gotoPosition(e,t=0){if(!t&&![u.Running,u.Paused].includes(this.state))return;e=Math.max(e,0);let i=1;this.sourceNode&&(m.sourceNode.onended=null,m.sourceNode.stop(),i=m.sourceNode.playbackRate.value),this.createSourceNode(),m.elapsedWithPreviousPlaybackRate=0,m.sourceNode.start(0,e),e/=i,m.started=m.context.currentTime-e,m.sourceNode.playbackRate.value=i}}m.PRECISION=1024,m.ended=1,m.started=0,m.elapsedWithPreviousPlaybackRate=0,m.pausedAt=0,l("kvg.Music",m);class f{constructor(e){this._running=0,this._started=0,this.timesig=new p,this.previoustime=0,this.onTick=e=>{if(this._running){if(window.requestAnimationFrame(this.onTick),m.ended){if(!this.demo.looping)return v.instance.emitChange(d.Stopped),void this.stop();m.ended=0,m.gotoPosition(0,1),this.demo.previousTs=new p(0,0,0),v.instance.overlay.hideAll()}var t=m.position();this.timesig.fromTime(t/60),this.timesig.delta=this.calculateDelta(e),this.demo.update(this.timesig),this.previoustime=e}},this.demo=e}get started(){return this._started}get delta(){return this.timesig.delta}start(){if(!this._started){m.start(),this._started=1,this._running=1,v.instance.emitChange(d.Running),window.requestAnimationFrame(this.onTick);const e=/#time=([0-9]+)/.exec(location.hash);e&&e.length>1?m.gotoPosition(parseInt(e[1])):0!==c().parts[0].start[0]&&m.gotoPosition(p.toMilliseconds(c().parts[0].start[0])/1e3)}}stop(){v.instance.emitChange(d.Stopped),m.stop(),this._running=0,this._started=0,m.reset()}pause(){v.instance.emitChange(d.Paused),m.pause()}resume(){v.instance.emitChange(d.Running),m.play()}seek(e){let t=e.toMilliseconds();t=Math.max(0,t),m.gotoPosition(t/1e3)}calculateDelta(e){return(e-this.previoustime)/(1e3/60)}}!function(e){e[e.Stopped=0]="Stopped",e[e.Running=1]="Running",e[e.Paused=2]="Paused"}(d||(d={}));class v{constructor(t){this.onUpdate=new e,this.onDebugUpdate=new e,this.onStateChange=new e,this.onRenderComplete=new e,this.beforeRender=new e,this.beforeUpdate=new e,this.activeParts=[],this.coDependant=[],this.previousTs=new p,this.state=d.Stopped,v.instance=this,this.looping=t.looping,this.renderer=t.renderer,this.options=t,this.overlay=t.overlay,this._runner=new f(this)}get runner(){return this._runner}getPart(e){let t;if(this.options.parts.forEach((i=>{i.id==e&&(t=i)})),!t)throw"Part "+e+"not found";return t}update(e){m.updateFFT();let t=0;for(;!e.equals(this.previousTs);){this.previousTs.isSmallerThan(e)?this.previousTs.addTicks(1):this.previousTs.subtractTicks(1),t=1,this.coDependant=[];const i=[];let s=0;for(let t=0;t<this.options.timeline.length;t++){let o=this.options.timeline[t];this.previousTs.isLargerThan(o.start)&&e.isSmallerThan(o.end)&&(o.partInstance.running||(o.partInstance.start(this.previousTs,o),s=1,o.partInstance.renderToScreen=!o.dontRenderToScreen),i.push(o.partInstance),o.requires.forEach((e=>{let t=this.getPart(e);-1==this.coDependant.indexOf(t)&&this.coDependant.push(t)})))}this.previousTs.delta=e.delta,this.coDependant.forEach((e=>e.runTriggers(this.previousTs))),i.forEach((e=>e.runTriggers(this.previousTs))),this.activeParts=i,s&&this.emitChange(d.Running),this.options.parts.forEach((e=>{-1==this.activeParts.indexOf(e)&&e.running&&e.stop()}))}t&&(this.beforeUpdate.emit({timesig:e}),this.onUpdate.emit({timesig:e})),c().debug&&this.onDebugUpdate.emit({timesig:e}),this.render(e)}renderAllOnce(){this.options.renderer.render(p.zero(),this.options.parts,1)}render(e){const t={timesig:e,rendered:[...this.coDependant,...this.activeParts]};this.beforeRender.emit(t),this.coDependant.length>0&&this.options.renderer.render(e,this.coDependant),this.activeParts.length>0&&this.options.renderer.render(e,this.activeParts),this.onRenderComplete.emit(t)}emitChange(e){this.state=e,e===d.Stopped&&this.onUpdate.emit({timesig:p.zero()}),this.onStateChange.emit({state:e,activeParts:this.activeParts})}}var g=i(0),x=i.n(g),y=i(1),b=i.n(y);const R=(e,t,i)=>{var s=e.createShader(i);if(e.shaderSource(s,t),e.compileShader(s),!e.getShaderParameter(s,e.COMPILE_STATUS))throw"Could not compile WebGL program. \n\n"+e.getShaderInfoLog(s);return s};let E=new Map;class P{constructor(e){this.enabled=1,this.renderer=e,this.textures=[e.createRenderTarget(),e.createRenderTarget()],this.fbs=[e.createFrameBuffer(this.textures[0]),e.createFrameBuffer(this.textures[1])]}render(e,t){const i=this.renderer.context;let s=0,o=e;i.drawBuffers([i.COLOR_ATTACHMENT0]),i.activeTexture(i.TEXTURE0),i.bindTexture(i.TEXTURE_2D,e);let r=0;t.posts.forEach((e=>{e.enabled&&this.enabled&&r++})),t.posts.forEach((e=>{if(e.enabled&&this.enabled){const a=s==r-1&&r>1?t.part?t.part.framebuffer:null:this.fbs[s%2];e.render(i,a,o,t.part),o=this.textures[s%2],i.activeTexture(i.TEXTURE0),i.bindTexture(i.TEXTURE_2D,o),s++}})),1==r&&t.part&&(i.bindFramebuffer(i.FRAMEBUFFER,t.part.framebuffer),i.drawBuffers([i.COLOR_ATTACHMENT0]),i.useProgram(this.renderer.program),i.activeTexture(i.TEXTURE0),i.drawArrays(i.TRIANGLES,0,3)),t.posts.forEach((e=>{if(e.enabled&&this.enabled){const a=s==r-1&&r>1?t.part?t.part.framebuffer:null:this.fbs[s%2];e.postRender(i,a,o,t.part)}}))}}class T{constructor(e){null==e.dpr&&(e.dpr=1),null==e.canvas&&(e.canvas=document.createElement("canvas")),null==e.width&&(e.width=1920),null==e.height&&(e.height=1080),null==e.dpr&&(e.dpr=1),null==e.alpha&&(e.alpha=0),null==e.depth&&(e.depth=0),null==e.failIfMajorPerformanceCaveat&&(e.failIfMajorPerformanceCaveat=1),null==e.powerPreference&&(e.powerPreference="high-performance"),null==e.premultipliedAlpha&&(e.premultipliedAlpha=0),null==e.preserveDrawingBuffer&&(e.preserveDrawingBuffer=0),null==e.stencil&&(e.stencil=0),null==e.background&&(e.background="#000"),this.options=e,this.options.width*=this.options.dpr,this.options.height*=this.options.dpr,this.context=this.createWebGlContext(),this.context.getExtension("EXT_color_buffer_float"),this.context.viewport(0,0,e.width,e.height),this.program=((e,t,i,s,o)=>{const r=t+i;if(E.has(r))return E.get(r);var a=e.createProgram();if(e.attachShader(a,R(e,t||x(),e.VERTEX_SHADER)),e.attachShader(a,R(e,i||b(),e.FRAGMENT_SHADER)),s&&o&&e.transformFeedbackVaryings(a,s,o),e.linkProgram(a),e.validateProgram(a),E.set(r,a),!e.getProgramParameter(a,e.LINK_STATUS))throw"program failed to link:"+e.getProgramInfoLog(a);return a})(this.context),this.context.useProgram(this.program),this.textureLocation=this.context.getUniformLocation(this.program,"texture"),this.buffer=this.context.createBuffer(),this.context.bindBuffer(this.context.ARRAY_BUFFER,this.buffer),this.context.bufferData(this.context.ARRAY_BUFFER,new Float32Array([1,1,1,-3,-3,1]),this.context.DYNAMIC_DRAW),this.postprocessing=new P(this)}createWebGlContext(){let e=this.options.canvas;e.id="demoCanvas",e.width=this.options.width,e.height=this.options.height,e.style.width=this.options.width/this.options.dpr+"px",e.style.height=this.options.height/this.options.dpr+"px",e.style.background=this.options.background;let t=e.getContext("webgl2",this.options);return t.pixelStorei(t.UNPACK_FLIP_Y_WEBGL,1),t}render(e,t,i=0){let s=t[0],o=null;for(let r=0;r<t.length;r++){let a=t[r];a.framebuffer?(a.setFramebuffer(),a.clearRendertarget(),a.preRender(e,this.context),a.render(e,a.renderTo,this.context),a.postRender(e,this.context,this.postprocessing),a.renderToScreen&&!i&&(s=a),a.renderDebug&&(o=a)):(a.preRender(e,this.context),a.render(e,a.renderTo,this.context),a.postRender(e,this.context,this.postprocessing))}i?(this.context.flush(),this.context.getError()):(this.context.enableVertexAttribArray(0),this.context.useProgram(this.program),this.context.bindFramebuffer(this.context.FRAMEBUFFER,null),this.context.activeTexture(this.context.TEXTURE0),this.context.bindTexture(this.context.TEXTURE_2D,o?o.renderTo:s.renderTo),this.context.uniform1i(this.textureLocation,0),this.context.drawArrays(this.context.TRIANGLES,0,3))}initParts(e){e.forEach((e=>{e.renderAlwaysToScreen||(e.renderTo=this.createRenderTarget(),e.framebuffer=this.createFrameBuffer(e.renderTo,void 0))}))}createFrameBuffer(e,t){const i=this.context.createFramebuffer();return this.context.bindFramebuffer(this.context.FRAMEBUFFER,i),t||(t=this.context.COLOR_ATTACHMENT0),this.context.framebufferTexture2D(this.context.FRAMEBUFFER,t,this.context.TEXTURE_2D,e,0),i}createRenderTarget(e,t,i){var s,o,r,a,n,c,l,h,u;e||(e=this.options.width),t||(t=this.options.height);const d=this.context.createTexture();this.context.bindTexture(this.context.TEXTURE_2D,d);const p=null!==(s=null==i?void 0:i.internalFormat)&&void 0!==s?s:this.context.RGBA16F,m=this.context.RGBA,f=this.context.FLOAT;return this.context.texImage2D(this.context.TEXTURE_2D,0,p,e,t,0,m,f,null),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_MIN_FILTER,null!==(r=null===(o=null==i?void 0:i.filter)||void 0===o?void 0:o.min)&&void 0!==r?r:this.context.LINEAR),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_MAG_FILTER,null!==(n=null===(a=null==i?void 0:i.filter)||void 0===a?void 0:a.mag)&&void 0!==n?n:this.context.LINEAR),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_WRAP_S,null!==(l=null===(c=null==i?void 0:i.wrapping)||void 0===c?void 0:c.wrapS)&&void 0!==l?l:this.context.CLAMP_TO_EDGE),this.context.texParameteri(this.context.TEXTURE_2D,this.context.TEXTURE_WRAP_T,null!==(u=null===(h=null==i?void 0:i.wrapping)||void 0===h?void 0:h.wrapT)&&void 0!==u?u:this.context.CLAMP_TO_EDGE),d}}class w{constructor(e=0,t=0){this.x=e,this.y=t}length(){return Math.sqrt(this.x*this.x+this.y*this.y)}lengthSquared(){return this.x*this.x+this.y*this.y}}class A{constructor(e){this.posts=new Map,this.part=e}As(){return Object.fromEntries(this.posts)}sort(e){this.posts=new Map([...this.posts.entries()].sort(((t,i)=>e.indexOf(t[0])-e.indexOf(i[0]))))}attach(e,t){if(t||(t=e.name),this.posts.has(t))throw new Error(`Adding a duplicate postprocess: ${t}`);this.posts.set(t,e)}deattach(e){this.posts.delete(e)}}var M,C,S;!function(e){e[e.max=0]="max",e[e.min=1]="min",e[e.average=2]="average"}(M||(M={}));class I{constructor(e){this.historySize=6,this.historyLeft=[],this.historyRight=[],this.filters=new Map;for(let e=0;e<m.PRECISION;e++)this.historyLeft.push([]),this.historyRight.push([]);"legacy"!==e||(this.update=this.updateLegacy)}As(){return Object.fromEntries([...this.filters.entries()])}addFilter(e,t){return null!=e||(e=`filter-${this.filters.entries.length}`),t||(t={low:0,high:5e3,isolate:1,channel:.5,result:{triggered:0,max:0,min:0,accumulated:0}}),this.filters.set(e,t),t}removeFilter(e){this.filters.delete(e)}update(){if(this.filters.forEach((e=>{e.result.min=v.instance.state!==d.Running?0:1,e.result.max=0,e.result.triggered=0})),v.instance.state!==d.Running)return;const e=m.fft,i=e.sampleRate/m.PRECISION;for(let r=0;r<e.frequencyLeft.length;r++){var s=this.historyLeft[r];for(s.push(e.frequencyLeft[r]/255);s.length>this.historySize;)s.shift();var o=this.historyRight[r];for(o.push(e.frequencyRight[r]/255);o.length>this.historySize;)o.shift();let a=0;s.forEach((e=>a+=e)),a/=this.historySize;let n=0;o.forEach((e=>n+=e)),n/=this.historySize;let c=i*r;this.filters.forEach((e=>{var i;let s=e.isolate?c>=e.low&&c<=e.high:c>e.high||c<e.low,o=t.lerp(a,n,e.channel)-(null!==(i=e.requireAmplitude)&&void 0!==i?i:0);s&&o>=0&&(e.result.min=e.result.min>o?o:e.result.min,e.result.max=e.result.max<o?o:e.result.max,e.result.triggered=1)}))}this.filters.forEach((e=>{e.result.triggered?e.accumulateType===M.min?e.result.accumulated+=e.result.min*v.instance.runner.delta:e.accumulateType===M.max?e.result.accumulated+=e.result.max*v.instance.runner.delta:e.result.accumulated+=(e.result.max+e.result.min)/2*v.instance.runner.delta:(e.result.min=0,e.result.max=0)}))}updateLegacy(){this.filters.forEach((e=>{e.result.min=1,e.result.max=0,e.result.triggered=0}));const e=m.fft,t=e.sampleRate/m.PRECISION;for(let o=0;o<e.frequencyLeft.length;o++){var i=this.historyLeft[o];for(i.push(e.frequencyLeft[o]/255);i.length>this.historySize;)i.shift();let r=0;i.forEach((e=>r+=e)),r/=this.historySize;let a=t*o,n=t*(o+1);this.filters.forEach((e=>{var t,i;if((e.isolate?a>=e.low&&a<=e.high:a>e.high||a<e.low)&&r>=(null!==(t=e.requireAmplitude)&&void 0!==t?t:0)){let t=r-(null!==(i=e.requireAmplitude)&&void 0!==i?i:0);t*=1-e.channel,e.result.min=e.result.min>t?t:e.result.min,e.result.max=e.result.max<t?t:e.result.max,e.result.triggered=1}}));var s=this.historyRight[o];for(s.push(e.frequencyRight[o]/255);s.length>this.historySize;)s.shift();r=0,s.forEach((e=>r+=e)),r/=this.historySize,a=t*o,n=t*(o+1),this.filters.forEach((e=>{var t,i;if((e.isolate?a>=e.low&&a<=e.high:a>e.high||a<e.low)&&r>=(null!==(t=e.requireAmplitude)&&void 0!==t?t:0)){let t=r-(null!==(i=e.requireAmplitude)&&void 0!==i?i:0);t*=e.channel,e.result.min=e.result.min>t?t:e.result.min,e.result.max=e.result.max<t?t:e.result.max,e.result.triggered=1}}))}this.filters.forEach((e=>{e.result.triggered&&(e.result.accumulated+=(e.result.max+e.result.min)/2)}))}}!function(e){e[e.Trigger=0]="Trigger",e[e.Reactor=1]="Reactor",e[e.Curve=2]="Curve"}(C||(C={})),function(e){e[e.EnablePostProcess=0]="EnablePostProcess",e[e.EnableAudioAnalyzer=1]="EnableAudioAnalyzer",e[e.DefaultPostProcess=2]="DefaultPostProcess",e[e.DefaultAudioFilters=3]="DefaultAudioFilters",e[e.DefaultOnRender=4]="DefaultOnRender"}(S||(S={}));const U=document.createElement("div");class L{constructor(){if(this.speeds=[],this.lastFrame=0,this.previousFrames=[],this.onUpdate=e=>{this.timestamp&&(this.timestamp.innerText=e.timesig.toString(0));const t=Date.now(),i=1e3/(t-this.lastFrame);this.lastFrame=t,this.previousFrames.push(i),this.previousFrames.length>10&&this.previousFrames.shift();const s=this.previousFrames.reduce(((e,t)=>e+t),0)/this.previousFrames.length;this.fpsCounter.innerText=s.toFixed(2).toString();const o=e.timesig.toMilliseconds();this.timestampMs.innerText=Math.floor(o).toString(),this.timestampSeconds.innerText=`${Math.floor(o/6e4)}:${Math.floor(o%6e4/1e3)}`},this.onPause=()=>{v.instance.state===d.Paused?v.instance.runner.resume():v.instance.runner.pause()},this.onLeft=e=>{this.moveTo(Math.max(0,m.position()-e))},this.onRight=e=>{this.moveTo(Math.min(m.duration,m.position()+e))},!c().debug)return;const e=document.getElementById("debug-placeholder");this.timestamp=document.createElement("div"),this.timestampMs=document.createElement("div"),this.timestampSeconds=document.createElement("div"),this.fpsCounter=document.createElement("div"),e.appendChild(this.timestamp),e.appendChild(this.timestampMs),e.appendChild(this.timestampSeconds),e.appendChild(this.fpsCounter);const t=function(e){return U.innerHTML=e,U.firstElementChild}("\n<div id='debug-speed-control' style='background:#505050'>\nplayback speed\n\n<input id='debug-speed-control-⅛' name='debug-speed' type=\"radio\" value=\"0.125\" />\n<label for='debug-speed-control-⅛'>⅛</label>\n\n<input id='debug-speed-control-¼' name='debug-speed' type=\"radio\" value=\"0.25\" />\n<label for='debug-speed-control-¼'>¼</label>\n\n<input id='debug-speed-control-½' name='debug-speed' type=\"radio\" value=\"0.5\" />\n<label for='debug-speed-control-½'>½</label>\n\n<input id='debug-speed-control-1' checked=\"checked\" name='debug-speed' type=\"radio\" value=\"1\" />\n<label for='debug-speed-control-1'>1</label>\n\n<input id='debug-speed-control-2' name='debug-speed' type=\"radio\" value=\"2\" />\n<label for='debug-speed-control-2'>2</label>\n\n<input id='debug-speed-control-4' name='debug-speed' type=\"radio\" value=\"4\" />\n<label for='debug-speed-control-4'>4</label>\n\n</div>\n");e.appendChild(t);const i=t.querySelectorAll('input[type=radio][name="debug-speed"]');Array.prototype.forEach.call(i,(e=>{e.addEventListener("change",(()=>{const t=e.getAttribute("value"),i=Number.parseFloat(t);m.adjustSpeed(i)}))})),v.instance.onUpdate.connect(this.onUpdate),window.addEventListener("keydown",(e=>{const t=e.ctrlKey?p.toMilliseconds(0,0,1)/1e3:e.shiftKey?10:1;"ArrowLeft"==e.key?this.onLeft(t):"ArrowRight"==e.key?this.onRight(t):" "==e.key&&(e.preventDefault(),this.onPause())}))}moveTo(e){m.gotoPosition(e)}}class O{constructor(){let e=0;const t=/1011..../,i=/1001..../,s=/1000..../;navigator.requestMIDIAccess().then((o=>{Array.from(o.inputs).forEach((o=>{o[1].onmidimessage=o=>{const r=o.data[0].toString(2);!e&&i.test(r)&&36==o.data[1]?e=1:e&&s.test(r)&&36==o.data[1]&&(e=0,m.adjustSpeed(1)),e&&t.test(r)&&1==o.data[1]&&m.adjustSpeed(0+(o.data[2]-64)/32)}}))}))}}class k{static set EnablePostProcessing(e){v.instance.renderer.postprocessing.enabled=e}}l("kvg.RuntimeConfig",k);class D{constructor(){var e;const t=document.createElement("div");t.innerHTML='<div><label>Enable postprocessing <input type="checkbox" checked/></label></div>',null===(e=document.getElementById("debug-placeholder"))||void 0===e||e.append(t);const i=t.getElementsByTagName("input")[0];i.addEventListener("change",(()=>{k.EnablePostProcessing=i.checked}))}}const z={automaticUniformSliderGeneration:1},B=localStorage.getItem("kvg-editor-options");if(B)try{const e=JSON.parse(B);Object.keys(e).forEach((t=>{Reflect.set(z,t,e[t])}))}catch(e){}var _;!function(e){e[e.f1=0]="f1",e[e.f1v=1]="f1v",e[e.i1=2]="i1",e[e.i1v=3]="i1v",e[e.f2=4]="f2",e[e.f2v=5]="f2v",e[e.i2=6]="i2",e[e.i2v=7]="i2v",e[e.f3=8]="f3",e[e.f3v=9]="f3v",e[e.i3=10]="i3",e[e.i3v=11]="i3v",e[e.f4=12]="f4",e[e.f4v=13]="f4v",e[e.i4=14]="i4",e[e.i4v=15]="i4v"}(_||(_={}));class q{constructor(e,t,{type:i,value:s,name:o,max:r,min:a,generateDebugSlider:n,programId:l}){this.enableDebug=0,this.changed=0,this.type=i,this.value=s,this.name=o,this.program=e,this.gl=t,this.location=t.getUniformLocation(e,o),this.changed=1,"_"!==this.name.charAt(0)&&z.automaticUniformSliderGeneration&&(n=1),n&&c().debugUniformSliders&&(this.enableDebug=1,r&&(this.max=r),a&&(this.min=a)),this.location}set value(e){this.changed=e!=this._value,this._value=e}get value(){return this._value}sync(){switch(this.changed,this.type){case _.f1:this.gl.uniform1f(this.location,this._value);break;case _.f1v:this.gl.uniform1fv(this.location,this._value);break;case _.i1:this.gl.uniform1i(this.location,this._value);break;case _.i1v:this.gl.uniform1iv(this.location,this._value);break;case _.f2:this.gl.uniform2f(this.location,this._value.x,this._value.y);break;case _.f2v:this.gl.uniform2fv(this.location,this._value);break;case _.i2:this.gl.uniform2i(this.location,this._value.x,this._value.y);break;case _.i2v:this.gl.uniform2iv(this.location,this._value);break;case _.f3:this.gl.uniform3f(this.location,this._value.x,this._value.y,this._value.z);break;case _.f3v:this.gl.uniform3fv(this.location,this._value);break;case _.i3:this.gl.uniform3i(this.location,this._value.x,this._value.y,this._value.z);break;case _.i3v:this.gl.uniform3iv(this.location,this._value);break;case _.f4:this.gl.uniform4f(this.location,this._value.x,this._value.y,this._value.z,this._value.w);break;case _.f4v:this.gl.uniform4fv(this.location,this._value);break;case _.i4:this.gl.uniform4i(this.location,this._value.x,this._value.y,this._value.z,this._value.w);break;case _.i4v:this.gl.uniform4iv(this.location,this._value)}this.changed=0}}function F(e){return e instanceof w||e instanceof class{constructor(e,t,i){this.x=e,this.y=t,this.z=i}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)}lengthSquared(){return this.x*this.x+this.y*this.y+this.z*this.z}}||e instanceof class{constructor(e=0,t=0,i=0,s=0){this.x=e,this.y=t,this.z=i,this.w=s}length(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)}lengthSquared(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w}}}function V(e){return Array.isArray(e)}function N(e){return"object"==typeof e&&Reflect.has(e,"range")&&Reflect.has(e,"string")}const H=new Map([[_.f1,1],[_.f1v,1],[_.f2,2],[_.f2v,2],[_.f3,3],[_.f3v,3],[_.f4,4],[_.f4v,4],[_.i1,1],[_.i1v,1],[_.i2,2],[_.i2v,2],[_.i3,3],[_.i3v,3],[_.i4,4],[_.i4v,4]]);function X(e){return[_.i1,_.i1v,_.i2,_.i2v,_.i3,_.i3v,_.i4,_.i4v].indexOf(e)>=0}const W=["x","y","z","w"];class ${constructor(e,t){var i;this.sliderContainers=[],this.isVector=0,this.hasMultipleSliders=0,this.uniform=e,this.isVector="object"==typeof e.value&&!Array.isArray(e.value);const s=document.createElement("div");s.classList.add("debug-container");const o=document.createElement("div"),r=document.createElement("label");o.classList.add("debug-label-container"),r.textContent=e.name,o.append(r),s.append(o);const a=null!==(i=H.get(e.type))&&void 0!==i?i:0;this.hasMultipleSliders=a>1;const n=e.value,c=e.max,l=e.min;this.defaultValue="object"==typeof e.value?Object.assign({},e.value):e.value;const h=[];for(let t=0;t<a;t++){const i=document.createElement("div");i.classList.add("debug-row-container"),this.sliderContainers.push(i);const o=1===a?"":W[t],r=Array.isArray(e.value);let u=this.getValue(l,t,0),d=this.getValue(c,t,100);const p=this.getValue(n,t,0);if(u=Math.min(u,p),d=Math.max(d,p),a>1){const e=document.createElement("label");e.textContent=o,i.append(e)}const m=document.createElement("input");m.type="range",m.classList.add("slider"),m.step=X(e.type)?"1":"0.001",m.max=d.toString(),m.min=u.toString(),m.value=p.toString(),m.addEventListener("input",this.onSliderChange(m,e,t)),h.push(m);const f=document.createElement("input");f.type="text",f.value="100",f.addEventListener("change",this.onValueChange(f,e,t,m)),i.append(m),i.append(f),s.append(i),v.instance.onDebugUpdate.connect((()=>{f!=document.activeElement&&(this.isVector||r?this.isVector?(m.value=Reflect.get(this.uniform.value,o),f.value=Reflect.get(this.uniform.value,o).toFixed(2)):(m.value=this.uniform.value[t].toString(),f.value=this.uniform.value[t].toFixed(2)):(m.value=this.uniform.value.toString(),f.value=this.uniform.value.toFixed(2)),this.minMaxUpdate(f,this.uniform,m))}))}const u=document.createElement("input");u.type="button",u.value="S",u.addEventListener("click",(()=>this.saveValues()));const d=document.createElement("input");d.type="button",d.value="R",d.addEventListener("click",(()=>this.resetDefaults())),o.append(u),o.append(d),t.append(s)}getValue(e,t,i){return e?F(e)?Reflect.get(e,W[t]):(s=e,Array.isArray(s)?e[t]:e):i;var s}parseValue(e,t){return X(t)?parseInt(e):parseFloat(e)}minMaxUpdate(e,t,i){const s=this.parseValue(e.value,t.type),o=this.parseValue(i.max,t.type),r=this.parseValue(i.min,t.type);[s,o,r].includes(NaN)||(i.max=Math.max(s,o,r).toString(),i.min=Math.min(s,o,r).toString())}onValueChange(e,t,i,s){return()=>{const o=this.parseValue(e.value,t.type);this.changeUniformValue(t,i,o),this.minMaxUpdate(e,t,s),s.value=o.toFixed(2)}}changeUniformValue(e,t,i){if(this.hasMultipleSliders){const s=e.value;this.isVector?s[W[t]]=i:s[t]=i,this.uniform.value=s}else this.uniform.value=i}onSliderChange(e,t,i){return()=>{const s=this.parseValue(e.value,t.type);this.changeUniformValue(t,i,s)}}resetDefaults(){"object"==typeof this.uniform.value?Object.assign(this.uniform.value,this.defaultValue):this.uniform.value=this.defaultValue}saveValues(){Object.assign(this.defaultValue,this.uniform.value),"object"==typeof this.uniform.value?Object.assign(this.defaultValue,this.uniform.value):this.defaultValue=this.uniform.value}destroy(){this.sliderContainers.forEach((e=>e.remove()))}}class Y{constructor(){this.container=document.createElement("div"),this.container.style.zIndex="50",this.container.style.background="none",this.container.addEventListener("mousemove",(e=>e.stopImmediatePropagation())),document.getElementById("debug-placeholder").append(this.container)}addPart(e){const t=document.createElement("div"),i=document.createElement("div"),s=document.createElement("div"),o=document.createElement("div");t.style.background="none",s.style.background="none",o.style.background="none";const r=document.createElement("div");r.style.display="flex",r.style.justifyContent="space-between";const a=document.createElement("input");a.type="button",a.value="Export",a.addEventListener("click",(t=>this.exportAsJson(t,e))),r.appendChild(a);const n=document.createElement("span");n.textContent="Postprocessing",r.appendChild(n);const c=document.createElement("div");c.textContent="Uniforms",i.style.cursor="pointer",i.style.background="rgba(64,168,64,0.95)",i.style.borderBottom="3px solid rgba(64,128,64,1.0)",r.style.background="rgba(128,128,255,0.95)",c.style.background="rgba(128,128,255,0.95)",i.style.cursor="pointer",r.style.cursor="pointer",c.style.cursor="pointer",s.style.marginLeft="10px",o.style.marginLeft="10px",i.textContent=e.id,t.append(i),t.append(s),t.append(o),this.container.append(t),s.append(r),o.append(c),t.style.height="25px",s.style.height="auto",o.style.height="auto",t.style.overflow="hidden",s.style.overflow="hidden",o.style.overflow="hidden",i.addEventListener("click",(()=>{t.style.height="auto"==t.style.height?"25px":"auto"})),r.addEventListener("click",(()=>{s.style.height="auto"==s.style.height?"22px":"auto"})),c.addEventListener("click",(()=>{o.style.height="auto"==o.style.height?"22px":"auto"})),e.postProcessing&&e.postProcessing.posts.forEach((e=>{const t=document.createElement("div"),i=document.createElement("div");i.style.cursor="pointer",i.textContent=e.constructor.name,i.style.textAlign="center",i.style.background="#603030",i.style.borderBottom="1px solid black",t.append(i),s.append(t),t.style.height="23px",t.style.overflow="hidden",i.addEventListener("click",(()=>{t.style.height="auto"==t.style.height?"23px":"auto"})),e.uniforms.forEach((e=>{e.forEach((e=>{e.enableDebug&&new $(e,t)}))}))})),function(e){return Reflect.has(e,"CreateUniform")}(e)&&e.uniforms.forEach((e=>{e.enableDebug&&new $(e,o)}))}exportAsJson(e,t){const i=["size","resolution"];e.stopImmediatePropagation();const s={};[...t.postProcessing.posts].forEach((e=>{const t={};[...e[1].uniforms].forEach((e=>{e[1].forEach((e=>{-1===i.indexOf(e.name)&&(t[e.name]=e.value)}))})),s[e.constructor.name]=t}))}}function Z(e){return Reflect.has(e,"CreateUniform")}class G{constructor(){this.active=0,this.camera=[0,0,0],this.target=[0,0,0],this.fov=1,this.keysDown=new Map,this.theta=0,this.phi=0,this.postRender=()=>{if(!this.active)return;const e=this.keysDown.get("shift")?10:1;this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)];const i=this.target[0]-this.camera[0],s=this.target[1]-this.camera[1],o=this.target[2]-this.camera[2],r=[i,s,o],a=t.normalize(t.cross(r,[0,1,0])),n=t.normalize(t.cross(r,[0,-1,0])),c=t.normalize(t.cross(r,a)),l=t.normalize(t.cross(r,n));this.keysDown.get("a")&&(this.camera[0]+=a[0]/100*e,this.camera[1]+=a[1]/100*e,this.camera[2]+=a[2]/100*e),this.keysDown.get("d")&&(this.camera[0]+=n[0]/100*e,this.camera[1]+=n[1]/100*e,this.camera[2]+=n[2]/100*e),this.keysDown.get("w")&&(this.camera[0]+=i/100*e,this.camera[1]+=s/100*e,this.camera[2]+=o/100*e),this.keysDown.get("s")&&(this.camera[0]-=i/100*e,this.camera[1]-=s/100*e,this.camera[2]-=o/100*e),this.keysDown.get("q")&&(this.camera[0]+=l[0]/100*e,this.camera[1]+=l[1]/100*e,this.camera[2]+=l[2]/100*e),this.keysDown.get("e")&&(this.camera[0]+=c[0]/100*e,this.camera[1]+=c[1]/100*e,this.camera[2]+=c[2]/100*e),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)],v.instance.activeParts.forEach((e=>{if(Z(e)){const t=e.uniforms.find((e=>"camera"==e.name));t&&(t.value=this.camera);const i=e.uniforms.find((e=>"fov"==e.name));i&&(i.value=this.fov);const s=e.uniforms.find((e=>"target"==e.name));s&&(s.value=this.target),this.debug.innerHTML="CAM:"+this.camera.map((e=>e.toFixed(2))).join(",")+"<br/>TGT:"+this.target.map((e=>e.toFixed(2))).join(",")}}))},this.readShaderValues=()=>{v.instance.activeParts.forEach((e=>{if(Z(e)){const t=e.uniforms.find((e=>"camera"==e.name));t&&(this.camera=t.value);const i=e.uniforms.find((e=>"fov"==e.name));i&&(this.fov=i.value);const s=e.uniforms.find((e=>"target"==e.name));s&&(this.target=s.value);const o=this.target[0]-this.camera[0],r=this.target[1]-this.camera[1],a=this.target[2]-this.camera[2],n=Math.sqrt(o*o+r*r+a*a);this.target[0]=this.camera[0]+o/n,this.target[1]=this.camera[1]+r/n,this.target[2]=this.camera[2]+a/n,this.theta=Math.acos(r/n),this.phi=Math.atan2(o/n,a/n),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)]}}))},this.debug=document.createElement("div"),this.debug.style.position="fixed",this.debug.style.top="0px",this.debug.style.left="0px",document.body.appendChild(this.debug),v.instance.beforeRender.connect(this.postRender),window.addEventListener("keydown",(e=>{this.keysDown.set(e.key.toLowerCase(),1),"§"==e.key&&(this.active=!this.active,this.active&&this.readShaderValues()),e.key})),window.addEventListener("keyup",(e=>{this.keysDown.set(e.key.toLowerCase(),0)}));let e=0,i=0;window.addEventListener("mousedown",(t=>{e=t.pageX,i=t.pageY})),window.addEventListener("mousemove",(s=>{if(1==s.buttons){const o=s.pageX-e,r=s.pageY-i;e=s.pageX,i=s.pageY,this.phi+=o/500,this.theta+=r/500,this.theta=t.clamp(.01,Math.PI-.01,this.theta),this.target=[this.camera[0]+Math.sin(this.theta)*Math.sin(this.phi),this.camera[1]+Math.cos(this.theta),this.camera[2]+Math.sin(this.theta)*Math.cos(this.phi)]}}))}}class j{constructor(e){this.aTS=new p,this.mouseMove=e=>{const t=e.pageX/window.innerWidth*this.totalTime.toMilliseconds();this.dragging===this.trackA&&t<this.bTS.toMilliseconds()&&(this.aTS.fromTime(Math.max(0,t)/1e3/60),this.updatePositions()),this.dragging===this.trackB&&t>this.aTS.toMilliseconds()&&(this.bTS.fromTime(Math.min(this.totalTime.toMilliseconds(),t)/1e3/60),this.updatePositions())},this.mouseUp=()=>{this.dragging=void 0},this.bTS=e.clone(),this.totalTime=e.clone(),this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.display="block",this.container.style.width="100%",this.container.style.height="22px",this.container.style.textAlign="center",this.container.style.userSelect="none",this.spacerContainer=document.createElement("div"),this.spacerContainer.style.position="absolute",this.spacerContainer.style.pointerEvents="none",this.spacerContainer.style.width="100%",this.spacerContainer.style.height="22px",this.spacerContainer.style.userSelect="none",this.container.appendChild(this.spacerContainer);for(let t=0;t<e.bar;t++){const i=document.createElement("span");i.textContent="|",i.style.fontWeight=t%4==0?"bold":"normal",i.style.position="absolute",i.style.textIndent="-4px",i.style.left=p.toMilliseconds(t,0,0)/e.toMilliseconds()*100+"%",this.spacerContainer.appendChild(i)}const t=document.createElement("span");t.style.marginLeft="-2px",t.style.width="4px",t.style.background="white",t.style.position="absolute",t.style.fontSize="20px",t.style.height="200px",t.style.zIndex="99",t.style.marginTop="4px",this.container.appendChild(t),v.instance.onDebugUpdate.connect((i=>{t.style.left=i.timesig.toMilliseconds()/e.toMilliseconds()*100+"%",this.aTS.toMilliseconds()>0&&this.bTS.toMilliseconds()<this.totalTime.toMilliseconds()&&(i.timesig.toMilliseconds()>this.bTS.toMilliseconds()||i.timesig.toMilliseconds()<this.aTS.toMilliseconds())&&m.gotoPosition(this.aTS.toMilliseconds()/1e3)})),this.trackA=document.createElement("div"),this.trackA.innerHTML="\n        <div style='background:green; width:14px; height:14px; transform:rotate(45deg); transform-origin:50% 50%; position:absolute; left:3px; top:10px;'></div>\n        <div style='background:green; position:absolute; width:20px; height:20px;'>A</div>\n        ",this.trackA.style.position="absolute",this.trackA.style.left="10%",this.trackA.style.top="-24px",this.trackA.style.width="20px",this.trackA.style.height="30px",this.trackA.style.marginLeft="-10px",this.container.appendChild(this.trackA),this.trackB=document.createElement("div"),this.trackB.innerHTML="\n        <div style='background:green; width:14px; height:14px; transform:rotate(45deg); transform-origin:50% 50%; position:absolute; left:3px; top:10px;'></div>\n        <div style='background:green; position:absolute; width:20px; height:20px;'>B</div>\n        ",this.trackB.style.position="absolute",this.trackB.style.right="10%",this.trackB.style.top="-24px",this.trackB.style.width="20px",this.trackB.style.height="30px",this.trackB.style.marginRight="-10px",this.container.appendChild(this.trackB),this.updatePositions(),this.trackA.addEventListener("pointerdown",this.startDrag(this.trackA)),this.trackB.addEventListener("pointerdown",this.startDrag(this.trackB)),window.addEventListener("pointerup",this.mouseUp),window.addEventListener("pointermove",this.mouseMove)}startDrag(e){return()=>{this.dragging=e}}updatePositions(){this.trackA.style.left=this.aTS.toMilliseconds()/this.totalTime.toMilliseconds()*100+"%",this.trackB.style.right=(this.totalTime.toMilliseconds()-this.bTS.toMilliseconds())/this.totalTime.toMilliseconds()*100+"%"}}const K=["#ff0000","#00ff00","#0000ff","#ffff00","#00ffff","#ff00ff"],J=["#151515","#050505"];let Q=0;class ee{constructor(e,t){this.markers={[C.Trigger]:{text:"T",absoluteBackground:"#5e5b00",relativeBackground:"a6a003"},[C.Curve]:{text:"C",absoluteBackground:"#75000b",relativeBackground:"#ad2633"},[C.Reactor]:{text:"R",absoluteBackground:"#0f5c00",relativeBackground:"#0e2e08"}},this.start=p.toMilliseconds(e.start[0],e.start[1],e.start[2]),this.end=p.toMilliseconds(e.end[0],e.end[1],e.end[2]),this.part=e,this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.display="block",this.container.style.width="100%",this.container.style.height="22px",this.container.style.background=J[Q%J.length],this.container.style.textAlign="center",this.container.innerHTML=`\n        <div style='display:inline-block;'>\n            <div style='position:relative'></div>\n            <span style='text-shadow: 0px 0px 4px black, 0px 0px 2px black'>${e.instanceId}</span>            \n        </div>\n        `;const i=this.container.children[0];i.style.position="absolute",i.style.background=K[Q%K.length],i.style.width=(this.end-this.start)/t.toMilliseconds()*100+"%",i.style.left=this.start/t.toMilliseconds()*100+"%",Q++}getMarker(e){const t=e.type,i=e.startAt.pattern===h.ABSOLUTE;var s=this.markers[t];const o=document.createElement("div");return o.style.width="10px",o.style.height="10px",o.style.fontSize="8px",o.style.color="white",o.style.backgroundColor=i?s.absoluteBackground:s.relativeBackground,o.innerHTML=s.text,o.style.position="absolute",o.style.zIndex="999",e.type===C.Curve&&(o.style.top="12px"),e.startAt.pattern===h.RELATIVE?o.style.left=e.startAt.toMilliseconds()/(this.end-this.start)*100+"%":e.startAt.pattern===h.ABSOLUTE&&(o.style.left=(e.startAt.toMilliseconds()-this.start)/(this.end-this.start)*100+"%"),o}attachTimelineEvents(e){e.forEach((e=>{if(!(e.startAt.toMilliseconds()>this.end)){var t=this.getMarker(e);this.container.children[0].children[0].append(t)}}))}}class te{constructor(){this.tracks=[],this.onPointerMove=e=>{if(1===e.buttons){const t=e.pageX/window.innerWidth*this.totalTime.toMilliseconds();m.gotoPosition(t/1e3)}},this.container=document.createElement("div"),this.container.id="debug-timeline",this.container.style.position="fixed",this.container.style.bottom="0px",this.container.style.left="0px",this.container.style.right="0px",this.container.style.background="black",this.container.addEventListener("pointermove",this.onPointerMove),this.container.addEventListener("pointerdown",this.onPointerMove),document.body.appendChild(this.container),this.buildTrack(c()),v.instance.options.parts.forEach((e=>{this.tracks.filter((t=>t.part.instanceId==e.id)).forEach((t=>t.attachTimelineEvents(e.getTimelineEvents())))}))}buildTrack(e){let t=e.parts[0].end;for(let i=1;i<e.parts.length;i++){const s=e.parts[i].end;s[0]>t[0]&&(t=s)}const i=new p(t[0],t[1],t[2],h.ABSOLUTE);this.totalTime=i,this.playHead=new j(i),this.playHead.container.style.bottom=22*e.parts.length+"px",this.container.appendChild(this.playHead.container),e.parts.forEach(((e,t)=>{const s=new ee(e,i);this.container.appendChild(s.container),this.tracks.push(s),s.container.style.top=22*t+"px",s.container.style.pointerEvents="none"})),this.container.style.height=22*e.parts.length+"px"}}class ie{constructor(){var e;const t=document.createElement("div");t.innerHTML="<div>Shader constants</div>";const i=c().shaderConstants;for(let e in i){const s=i[e],o=document.createElement("div");if(o.innerHTML=`${e}:${s}`,o.style.width="150px","#"===s.charAt(0))o.style.background=s;else if(s.indexOf("vec")>=0){const t=s.substr(5).split(",").map((e=>Math.round(255*parseFloat(e)))),i="#"+(t[0]<<16|t[1]<<8|t[2]).toString(16);o.style.background=`rgb(${t[0]},${t[1]},${t[2]}`,o.innerHTML=`${e}:${i}`;const r=(t[0]+t[1]+t[2])/3<128?"#ffffff":"#000000";o.style.color=r}t.appendChild(o)}t.style.position="fixed",t.style.top="50px",t.style.left="0px",null===(e=document.getElementById("debug-placeholder"))||void 0===e||e.appendChild(t)}}class se{constructor(){var e,i;this.canvasW=512,this.canvasH=512,this.low=0,this.high=24e3,this.zoom=4,this.enabled=0,this.lowTrigger=0,this.highTrigger=1,this.update=()=>{this.ctx.clearRect(0,0,this.canvasW,this.canvasH),this.analyzer.update();const e=t.clamp(0,255,(this.filter.result.max-this.lowTrigger)/(this.highTrigger-this.lowTrigger)*255);this.ctx.fillStyle=`#${(0|e).toString(16).padStart(2,"0")}0000`,this.ctx.fillRect(0,0,this.canvasW,this.canvasH),this.ctx.fillStyle="#ffffff";const i=this.container.getElementsByTagName("select")[0].value;if("waveform"===i){this.ctx.strokeStyle="#ffffff",this.ctx.lineWidth=1,this.ctx.beginPath(),this.ctx.moveTo(0,this.canvasH/2);for(let e=0;e<this.canvasW;e++){let t=Math.floor(e/this.canvasW*m.PRECISION);const i=m.fft.waveformLeft[t]/128*this.canvasH/2;this.ctx.lineTo(e,i)}this.ctx.stroke()}else if("frequency"===i){let e=0;this.lowTrigger,this.canvasH,this.highTrigger,this.canvasH;for(let t=0;t<m.PRECISION/this.zoom;t++){let i=m.fft.frequencyLeft[t];t<this.low/(this.context.sampleRate/m.PRECISION)||t>this.high/(this.context.sampleRate/m.PRECISION)?this.ctx.fillStyle="#333333":(this.ctx.fillStyle="#ffffff",e=Math.max(e,i));const s=i/255*this.canvasH;this.ctx.fillRect(Math.floor(t/m.PRECISION*this.canvasW)*this.zoom,this.canvasH-s,this.zoom,s)}this.ctx.strokeStyle="rgba(0,255,0,1)",this.ctx.beginPath(),this.ctx.rect(this.low/this.context.sampleRate*this.zoom*this.canvasW|0,(1-this.highTrigger)*this.canvasH|0,(this.high-this.low)/this.context.sampleRate*this.zoom*this.canvasW|0,(this.highTrigger-this.lowTrigger)*this.canvasH|0),this.ctx.stroke(),this.ctx.strokeStyle="rgba(0,0,0,0)",this.container.querySelector("#debug-fft-peak").textContent=e+":"+(e/255).toFixed(3)}else if("db"===i)for(let e=0;e<m.PRECISION;e++){const t=this.canvasH+m.fft.dbLeft[e];this.ctx.fillRect(Math.floor(e/m.PRECISION*this.canvasW),this.canvasH-t,1,t)}},this.container=document.createElement("div"),this.container.innerHTML='\n        <select  style=\'float:left\'>\n            <option value="frequency">Frequency</option>\n            <option value="waveform">Waveform</option>\n            <option value="db">Db</option>\n        </select>\n        <label style="float:right">Enable frequency isolation<input type="checkbox"/></label>\n        <canvas style="clear:both; display:block" transform-origin:0 0\'></canvas>\n        <br/>\n        <div style=\'float:left\' id=\'debug-fft-left\'>2000hz</div>\n        <div style=\'float:right\' id=\'debug-fft-right\'>4000hz</div>\n        <br/>\n        <div id=\'debug-fft-peak\' style="clear:both">2000hz</div>\n        ',this.container.style.transform="scale(0.5, 0.5)",this.container.style.transformOrigin="0 0",this.container.style.zIndex="99",this.canvas=this.container.getElementsByTagName("canvas")[0],this.canvas.width=this.canvasW,this.canvas.height=this.canvasH,this.ctx=this.canvas.getContext("2d"),this.container.style.position="fixed",this.container.style.top="300px",this.container.style.left="10px",v.instance.onDebugUpdate.connect(this.update),null===(e=document.getElementById("debug-placeholder"))||void 0===e||e.appendChild(this.container),this.gainNode=m.gainNode,this.context=m.context,null===(i=this.container.querySelector("input"))||void 0===i||i.addEventListener("click",(()=>{this.enabled=!this.enabled,this.enabled?(this.container.style.transform="scale(1,1)",this.gainNode.disconnect(this.context.destination),this.gainNode.connect(this.bandPass).connect(this.context.destination)):(this.lowTrigger=0,this.highTrigger=1,this.low=0,this.high=this.context.sampleRate,this.container.style.transform="scale(0.5,0.5)",this.gainNode.disconnect(this.bandPass),this.bandPass.disconnect(this.context.destination),this.gainNode.connect(this.context.destination))})),this.bandPass=this.context.createBiquadFilter(),this.bandPass.type="bandpass",this.bandPass.frequency.value=2e3,this.bandPass.Q.value=1,this.analyzer=new I(c().analyserVersion),this.filter=this.analyzer.addFilter(),this.filter.low=0,this.filter.channel=0,this.filter.high=this.context.sampleRate,this.canvas.addEventListener("mousedown",(e=>{if(!this.enabled)return;const i=e.target.getBoundingClientRect(),s=e.clientX-i.left;this.low=t.clamp(0,this.context.sampleRate,s/this.zoom/this.canvasW*this.context.sampleRate);const o=e.clientY-i.top;this.lowTrigger=t.clamp(0,1,(this.canvasH-o)/this.canvasH),this.setupBandPass(this.low,this.high)})),this.canvas.addEventListener("mousemove",(e=>{if(this.enabled&&1===e.buttons){const i=e.target.getBoundingClientRect(),s=e.clientX-i.left,o=t.clamp(0,this.context.sampleRate,s/this.zoom/this.canvasW*this.context.sampleRate);o<this.low?this.low=o:this.high=o;const r=e.clientY-i.top;this.highTrigger=t.clamp(0,1,(this.canvasH-r)/this.canvasH),this.setupBandPass(this.low,this.high),e.preventDefault()}})),this.canvas.addEventListener("mouseup",(e=>{if(!this.enabled)return;const i=e.target.getBoundingClientRect(),s=e.clientX-i.left,o=t.clamp(0,this.context.sampleRate,s/this.zoom/this.canvasW*this.context.sampleRate);o<this.low?this.low=o:this.high=o;const r=e.clientY-i.top;this.highTrigger=t.clamp(0,1,(this.canvasH-r)/this.canvasH),this.setupBandPass(this.low,this.high)}))}setupBandPass(e,t){0===e&&(e=1),e===t&&(t=e+Math.ceil(this.context.sampleRate/m.PRECISION));const i=Math.sqrt(e*t);if(this.bandPass.frequency.value=i,this.bandPass.Q.value=i/(t-e),this.high=t,this.low=e,this.highTrigger<this.lowTrigger){const e=this.lowTrigger;this.lowTrigger=this.highTrigger,this.highTrigger=e}this.highTrigger,this.lowTrigger,this.filter.low=this.low,this.filter.high=this.high,this.container.querySelector("#debug-fft-left").textContent=this.low.toString()+"Hz : "+this.lowTrigger.toPrecision(2),this.container.querySelector("#debug-fft-right").textContent=this.high.toString()+"Hz : "+this.highTrigger.toPrecision(2)}}class oe{static INIT(){if(!c().debug)throw"Tried to initialize debug without debug flag";oe.runtimePanel=new D,oe.timecontrol=new L,oe.midiControl=new O,oe.sliders=new Y,oe.runTimeCameraControl=new G,oe.shaderConstants=new ie,oe.fftDisplay=new se,oe.timeline=new te;const e=document.getElementById("demo");e&&(e.classList.add("enable-cursor"),e.style.position="relative"),v.instance.options.parts.forEach((e=>{oe.sliders.addPart(e)}));const t=document.getElementById("debug-placeholder");location.hash.indexOf("hideDebug")>=0&&(t.style.display="none"),document.addEventListener("keypress",(e=>{"m"===e.key&&(t.style.display="none"===t.style.display?"":"none")}))}}function re(e){return new Promise((t=>{window.setTimeout(t,e)}))}l("kvg.Debug",oe);class ae{constructor(e,t,i,s){this.shaderCache=new Map,this.build=async(e,t)=>{this.timeline.forEach((e=>{if(-1==this.parts.indexOf(e.partInstance))throw`Missing instantiated part for ${e.id}. Check your configuration and Main.ts`}));var i=new v({overlay:this.overlay,parts:this.parts,renderer:this.renderer,timeline:this.timeline,looping:this.config.looping});const s=this.renderer.context;this.parts.map((e=>e.initPreCompile())),t&&t.onPartPreCompile&&this.parts.filter((e=>e.features.has(S.DefaultPostProcess))).map((e=>t.onPartPreCompile(e))),this.parts.map((e=>e.onStandardComplete()));const o=this.parts.map((e=>({Id:e.id,Shaders:e.getPrograms()}))),r=window.navigator.userAgent.indexOf("Firefox")>=0;if(this.config.enableKHRParallelCompilation&&!r){s.getExtension("KHR_parallel_shader_compile")}e(.1),await re(50);const a=o.map((t=>{var i,o,r;const a=[];for(let n=0;n<t.Shaders.length;n++){const c=t.Shaders[n],l=this.replaceConstants(null!==(i=c.vertexShader)&&void 0!==i?i:x(),this.config.shaderConstants);let h=this.shaderCache.get(l);if(!h){h=s.createShader(s.VERTEX_SHADER),s.shaderSource(h,l),s.compileShader(h);if(!s.getShaderParameter(h,s.COMPILE_STATUS)){s.getShaderInfoLog(h)}this.shaderCache.set(l,h)}const u=this.replaceConstants(null!==(o=c.fragmentShader)&&void 0!==o?o:b(),this.config.shaderConstants);let d=this.shaderCache.get(u);if(!d){d=s.createShader(s.FRAGMENT_SHADER),s.shaderSource(d,u),s.compileShader(d);if(!s.getShaderParameter(d,s.COMPILE_STATUS)){document.getElementsByTagName("body")[0].classList.add("error");s.getShaderInfoLog(d)}this.shaderCache.set(u,d)}const p=null!==(r=c.program)&&void 0!==r?r:s.createProgram();s.attachShader(p,h),s.attachShader(p,d),this.config.debug&&(p.dbg={part:t.Id,fragment:c.fragmentShader,vertex:c.vertexShader}),a.push({vs:h,fs:d,program:p,customProgram:void 0!==c.program}),e(.1+n/a.length*.3)}return{id:t.Id,shaders:t.Shaders,programs:a}}));return a.forEach(((t,i)=>{t.programs.forEach((e=>{s.linkProgram(e.program)})),e(.4+.1*i/a.length)})),await this.checkLinkingStatus(a,s,e),a.forEach((e=>e.programs.forEach((e=>{e.customProgram||this.useShader(s,e.program)})))),a.forEach((e=>this.getPart(e.id).updateProgram(e.programs))),this.parts.forEach((e=>{t&&t.onPartInit&&(e.features.has(S.DefaultAudioFilters)||e.features.has(S.DefaultPostProcess))&&t.onPartInit(e),e.init()})),this.renderer.initParts(this.parts),this.parts.forEach((e=>e.postInit())),t&&i.beforeRender.connect((e=>{e.rendered.forEach((i=>{i.features.has(S.DefaultOnRender)&&t.onPartRender(e.timesig,i)}))})),this.config.debug&&oe.INIT(),i},this.useShader=(e,t)=>{e.useProgram(t);var i=e.getAttribLocation(t,"a_position"),s=e.createBuffer();e.bindBuffer(e.ARRAY_BUFFER,s);e.bufferData(e.ARRAY_BUFFER,new Float32Array([1,1,1,-3,-3,1]),e.STATIC_DRAW);var o=e.createVertexArray();e.bindVertexArray(o),e.enableVertexAttribArray(i),e.viewport(0,0,e.canvas.width,e.canvas.height),e.clearColor(0,0,0,0),e.clear(e.COLOR_BUFFER_BIT),e.useProgram(t),e.uniform2fv(e.getUniformLocation(t,"resolution"),[this.renderer.options.width,this.renderer.options.height]),e.bindVertexArray(o)},this.buildTimeline=()=>this.config.parts.map(((e,t)=>{var i;return{id:e.instanceId,part:e.instanceId,partInstance:this.getPart(e.instanceId),start:a(e.start),end:a(e.end),requires:null!==(i=e.requires)&&void 0!==i?i:[],options:e.options,dontRenderToScreen:e.dontRenderToScreen}})),this.getPart=e=>{var t;return null!==(t=this.parts.find((t=>t.id==e)))&&void 0!==t?t:{}},this.renderer=e,this.overlay=t,this.config=i,this.parts=s,this.timeline=this.buildTimeline(),n=i}checkLinkingStatus(e,t,i){return new Promise((async s=>{const o=e.map((e=>e.programs)).flat().map((e=>e.program));let r;for(;r=function*(e,t){const i=t.getExtension("KHR_parallel_shader_compile");let s=e.slice();for(;s.length;){if(i)s=s.filter((e=>!t.getProgramParameter(e,i.COMPLETION_STATUS_KHR)));else{const e=s.pop();t.getProgramParameter(e,t.LINK_STATUS)}if(!s.length)return;i&&(yield 1-s.length/e.length)}}(o,t).next(),r.done?i(1):i(.5+.5*r.value),!r.done;)await new Promise((e=>setTimeout(e,50)));s()}))}replaceConstants(e,i){if(!e)return e;for(let s in i)"#"==i[s][0]&&(i[s]=`vec3(${t.hexToArray(parseInt(i[s].substr(1),16)).join(",")})`),e=e.replace(new RegExp("\\$\\{"+s+"\\}","g"),i[s]);return e}}class ne{constructor(e,t){this.elements=new Map,this.width=1280,this.height=720,this.images=e,this.textures=t,this.container=document.createElement("div"),this.container.style.position="absolute",this.container.style.zIndex="10",this.container.style.background="transparent",this.container.style.overflow="hidden"}async preload(){return new Promise((e=>{let t=0,i=this.images.length+this.textures.length;0==i&&e(),this.images.forEach((s=>{const o=document.createElement("img");o.onload=()=>{++t==i&&e()},o.src=s,this.elements.set(s,o),this.container.appendChild(o),o.style.position="absolute",-1==o.src.indexOf("logo")?(o.classList.add("hide"),o.classList.add("animate")):o.style.display="none"})),this.textures.forEach((s=>{const o=document.createElement("img");o.onload=()=>{++t==i&&e()},o.src=s,this.elements.set(s,o)}))}))}resize(e,t){this.width=e,this.height=t,this.container.style.width=e+"px",this.container.style.height=t+"px",this.elements.forEach((t=>{if(this.images.indexOf(t.src)>=0){const i=e/1920;t.style.width=i*t.width+"px",t.style.height=i*t.height+"px",t.style.left=i*(this.width-t.width)/2+"px",t.style.top=i*(this.height-t.height)/2+"px"}}))}showImage(e,t={x:0,y:0},i="show"){if(!this.elements.has(e))return;const s=this.elements.get(e);s.classList.add(i),s.style.display="block",s.id=e;const o=this.width/1920;s.style.left=t.x*o-s.width/2+"px",s.style.top=t.y*o-s.height/2+"px"}hide(e,t){if(!this.elements.has(e))return;const i=this.elements.get(e);t?null==i||i.classList.add(t):null==i||i.classList.remove("show")}hideAll(){this.elements.forEach((e=>{e.style.display="none"}))}}class ce{constructor(e,t){this.gl=e,this.fftDataCanvas=document.createElement("canvas"),this.fftDataCanvas.width=m.PRECISION,this.fftDataCanvas.height=2,this.fftDataContext=this.fftDataCanvas.getContext("2d"),this.imageData=this.fftDataContext.getImageData(0,0,m.PRECISION,2),this.texture=t.createRenderTarget(m.PRECISION,2)}update(){for(let e=0;e<m.PRECISION;e++)this.imageData.data[4*e]=m.fft.frequencyLeft[e],this.imageData.data[4*e+1]=m.fft.frequencyLeft[e],this.imageData.data[4*e+2]=m.fft.frequencyLeft[e],this.imageData.data[4*e+3]=255,this.imageData.data[4*e+2048]=m.fft.frequencyRight[e],this.imageData.data[4*e+2048+1]=m.fft.frequencyRight[e],this.imageData.data[4*e+2048+2]=m.fft.frequencyRight[e],this.imageData.data[4*e+2048+3]=255;this.fftDataContext.putImageData(this.imageData,0,0),this.gl.bindTexture(this.gl.TEXTURE_2D,this.texture),this.gl.texImage2D(this.gl.TEXTURE_2D,0,this.gl.RGBA,this.gl.RGBA,this.gl.UNSIGNED_BYTE,this.fftDataCanvas)}}class le{constructor(e,t,i,s){var o;if(this.inputResolutions=[],this.partsById=new Map,this.testWebglFeatures=()=>{const e=document.createElement("canvas").getContext("webgl2");if(!e)return" Webgl2 not supported. Demo will not work.";return e.getExtension("KHR_parallel_shader_compile")?void 0:" Paraller compilation not supported. Startup might hang browser for a moment."},this.onDomContentReady=async()=>{var e,t,i;document.removeEventListener("DOMContentLoaded",this.onDomContentReady);const s=this.testWebglFeatures();if(s){const e=document.getElementById("webglWarning");e.style.display="block",e.childNodes[1].textContent=s}"file:"===document.location.protocol&&this.showLocalFileWarning(),this.showZoomWarning(),window.addEventListener("resize",this.showZoomWarning),document.title=this.config.title,document.getElementById("title").textContent=this.config.title,document.querySelector("#aspectLock label").textContent="Lock "+(N(this.config.aspectRatio)?this.config.aspectRatio.string:"16:9"),this.setupContainer=document.getElementById("setup"),this.setupContainer.style.display="none",this.demoContainer=document.getElementById("demo"),this.loaderContainer=document.getElementById("loader"),this.demoLauncherBar=document.getElementById("launcherBar"),this.demoLauncherBarText=document.getElementById("launcherBarText");const o=document.getElementById("resolution");null===(e=this.config.resolutions)||void 0===e||e.forEach((e=>{const t=document.createElement("input");t.type="radio",t.name="resolution",t.value=e.string,t.id=`resolution-${e.string}`;const i=document.createElement("label");i.setAttribute("for",t.id),i.textContent=e.string,i.classList.add("btn","btn-default"),e.default&&(i.classList.add("active"),t.checked=1),o.appendChild(t),o.appendChild(i),this.inputResolutions.push(t)})),this.inputDPRQ=document.getElementById("setup-dpr-q"),this.inputDPR0=document.getElementById("setup-dpr-0"),this.inputDPR1=document.getElementById("setup-dpr-1"),this.inputDPR2=document.getElementById("setup-dpr-2"),this.inputDPR3=document.getElementById("setup-dpr-3"),this.inputLockAspect=document.getElementById("setup-aspect-lock"),this.inputAAOff=document.getElementById("setup-aa-0"),this.inputAA2x=document.getElementById("setup-aa-2"),this.inputAA4x=document.getElementById("setup-aa-4"),this.inputAA8x=document.getElementById("setup-aa-8"),this.inputMuted=document.getElementById("setup-muted"),this.inputDebug=document.getElementById("setup-debug"),this.buttonStartFullscreen=document.getElementById("setup-fullscreen"),this.buttonStartWindowed=document.getElementById("setup-windowed"),this.looping=document.getElementById("setup-looping"),this.inputDPRQ.onclick=this.inputDPR0.onclick=this.showLowDprWarning,this.inputDPR2.onclick=this.inputDPR3.onclick=this.showHighDprWarning,this.inputDPR1.onclick=this.hideDprWarning,this.buttonStartFullscreen.onclick=this.onFullScreenClick,this.buttonStartWindowed.onclick=this.onWindowedClick;const r=this.config.shaderConstants["AA-LEVEL"];"0.0"===r?this.inputAAOff.checked=1:"2.0"===r?this.inputAA2x.checked=1:"4.0"===r?this.inputAA4x.checked=1:"8.0"===r&&(this.inputAA8x.checked=1),window.innerWidth,this.loadSettings(),this.overlay=new ne(null!==(t=this.config.images)&&void 0!==t?t:[],null!==(i=this.config.textures)&&void 0!==i?i:[]),await this.overlay.preload(),m.INIT(),m.onMusicLoaded.connect((()=>{this.setupContainer.style.display="",this.loaderContainer.style.display="none"})),m.loadMusic(this.config.music)},this.onFullScreenClick=async()=>{this.setupContainer.style.display="none",await this.demoContainer.requestFullscreen({}),await re(5e3),this.buildDemo()},this.onWindowedClick=async()=>{this.setupContainer.style.display="none",await re(10),this.buildDemo()},this.determineDPR=()=>{var e,t,i,s,o;let r=window.devicePixelRatio;return isNaN(r)&&(r=1),(null===(e=this.inputDPRQ)||void 0===e?void 0:e.checked)?r=.25:(null===(t=this.inputDPR0)||void 0===t?void 0:t.checked)?r=.5:(null===(i=this.inputDPR1)||void 0===i?void 0:i.checked)?r=1:(null===(s=this.inputDPR2)||void 0===s?void 0:s.checked)?r=2:(null===(o=this.inputDPR3)||void 0===o?void 0:o.checked)&&(r=3),r},this.determineAA=()=>{let e="0.0";return this.inputAA2x.checked?e="2.0":this.inputAA4x.checked?e="4.0":this.inputAA8x.checked&&(e="8.0"),"0.0"},this.determineResolution=()=>{const e=new w(1920,1080);let t=N(this.config.aspectRatio)?this.config.aspectRatio.range:this.config.aspectRatio;V(t)&&(t=t[0]);const i=this.inputResolutions.find((e=>e.checked)),s=this.config.resolutions.find((e=>e.string===(null==i?void 0:i.value))).resolution;if(V(s)?(e.x=s[0],e.y=s[1]):-1!==s&&(e.x=t*s,e.y=s),-1===s||e.x>window.innerWidth||e.y>window.innerHeight){var o=window.innerHeight,r=window.innerWidth;this.inputLockAspect.checked&&(r/t<o&&(o=r/t),o*t<r&&(r=o*t)),e.y=o,e.x=r}return e},this.buildDemo=()=>{var e,t,i;this.config.debug=(null===(e=this.inputDebug)||void 0===e?void 0:e.checked)&&this.config.debug,this.config.looping=this.looping&&this.looping.checked,this.config.debugUniformSliders=this.config.debugUniformSliders&&-1===location.hash.indexOf("disableUniformDebug");const s=document.getElementsByClassName("debug");for(let e=0;e<s.length;e++)s[e].style.display=this.config.debug?"":"none";const o=this.determineDPR(),r=this.determineResolution(),a=this.determineAA();this.config.shaderConstants["AA-LEVEL"]=a,this.config.muted=null!==(i=null===(t=this.inputMuted)||void 0===t?void 0:t.checked)&&void 0!==i?i:1,this.saveSettings(),this.renderer=new T({width:r.x,height:r.y,dpr:o,alpha:1});const n=this.demoContainer.firstElementChild;n.appendChild(this.renderer.options.canvas),this.demoContainer.style.display="";const c=this.renderer.options.height/1080;this.demoContainer.getElementsByTagName("img")[0].style.transform=`scale(${c},${c})`,this.demoLauncherBar.style.transform=`scale(${c},${c})`,this.demoLauncherBar.style.marginTop=this.renderer.options.height/2-45+"px",this.demoLauncherBarText.style.marginTop=this.renderer.options.height/2-70+"px",this.overlay.resize(r.x,r.y),n.appendChild(this.overlay.container),this.creationEvents&&this.creationEvents.onSetup&&this.creationEvents.onSetup(this),setTimeout(this.buildDelay,100)},this.delayMessages={5:"WebGL is now compiling shaders. This may take a moment.",20:"Modern browsers have an excellent shader cache - the demo should load up quickly on second run.",30:"If you selected 2xAA, shader compilation time is quadrupled. Demo should load any second now...",60:"Compilation time has taken over one minute. The demo should load up very soon!",120:"You selected 4xAA, didn't you?"},this.buildDelay=async()=>{const e=new Date,t=await new ae(this.renderer,this.overlay,this.config,this.parts).build((t=>{this.demoLauncherBar.children[0].style.width=100*t+"%";const i=(new Date-e)/1e3;let s="";i>5&&(s=this.delayMessages[5]),i>20&&(s=this.delayMessages[20]),i>30&&(s=this.delayMessages[30]),i>60&&(s=this.delayMessages[60]),i>120&&(s=this.delayMessages[120]),this.demoLauncherBarText.innerHTML=s}),this.defaultPartCallbacks);this.demo=t,this.creationEvents&&this.creationEvents.onBuilt&&this.creationEvents.onBuilt(t),this.config.generateFFT&&(m.FFTex=new ce(t.renderer.context,t.renderer),t.beforeRender.connect((e=>m.FFTex.update()))),window.demo=t,setTimeout(this.startDelay,100)},this.startDelay=()=>{this.demoLauncherBar.remove(),this.demoLauncherBarText.remove();const e=this.demoContainer.getElementsByTagName("img")[0];this.creationEvents&&this.creationEvents.onStart&&this.creationEvents.onStart(this.demo),this.demo.runner.start(),window.setTimeout((()=>e.remove()),50)},this.showZoomWarning=()=>{var e,t;const i=window.outerWidth>window.screen.availWidth||window.outerHeight>window.screen.availHeight,s=Math.abs(window.innerWidth-window.outerWidth)<20||window.innerHeight<window.outerHeight&&Math.abs(window.innerHeight-window.outerHeight)<120;(i?window.screen.availWidth===window.innerWidth&&window.screen.availHeight===window.innerHeight:s)?null===(t=document.getElementById("zoomWarning"))||void 0===t||t.setAttribute("style","display:none"):null===(e=document.getElementById("zoomWarning"))||void 0===e||e.setAttribute("style","display:block")},this.showLowDprWarning=()=>{var e;null===(e=document.getElementById("dpLowWarning"))||void 0===e||e.setAttribute("style","display:block")},this.showHighDprWarning=()=>{var e;null===(e=document.getElementById("dpHighWarning"))||void 0===e||e.setAttribute("style","display:block")},this.hideDprWarning=()=>{var e,t;null===(e=document.getElementById("dpLowWarning"))||void 0===e||e.setAttribute("style","display:none"),null===(t=document.getElementById("dpHighWarning"))||void 0===t||t.setAttribute("style","display:none")},this.showLocalFileWarning=()=>{var e;null===(e=document.getElementById("localFileWarning"))||void 0===e||e.setAttribute("style","display:block")},null==e)throw new Error("invalid configuration");e={...new r,...e},this.creationEvents=i,this.defaultPartCallbacks=s,m.PRECISION=null!==(o=e.precision)&&void 0!==o?o:m.PRECISION;const a=/#config=([^#]*)/.exec(location.hash);a&&(e.parts=[JSON.parse(decodeURI(a[1]))],t=t.filter((t=>null!=e.parts.find((e=>e.instanceId==t.id)))));const n=/#part=([^#]*)/.exec(location.hash);if(n){const i=n[1];e.parts=[{instanceId:i,start:[0,0,0],end:[140,0,0]}],t=t.filter((e=>e.id==i))}t.forEach((e=>{if(this.partsById.has(e.id))throw new Error("Trying to initialize part with existing name '"+e.id+"'");this.partsById.set(e.id,e)})),this.config=e,this.parts=t,"loading"==document.readyState?document.addEventListener("DOMContentLoaded",this.onDomContentReady):this.onDomContentReady()}loadSettings(){let e=localStorage.getItem(c().debug?"kvg-settings-debug":"kvg-settings");if(e){try{e=JSON.parse(e),!this.inputMuted||(this.inputMuted.checked=e.muted),!this.inputLockAspect||(this.inputLockAspect.checked=e.lockAspect),!this.inputDebug||(this.inputDebug.checked=e.debug),.25==e.dpr?this.inputDPRQ.checked=1:.5==e.dpr?this.inputDPR0.checked=1:[this.inputDPR1,this.inputDPR2,this.inputDPR3][e.dpr-1].checked=1,this.inputResolutions[e.resolution].checked=1,"0.0"===e.aa?this.inputAAOff.checked=1:"2.0"===e.aa?this.inputAA2x.checked=1:"4.0"===e.aa?this.inputAA4x.checked=1:"8.0"===e.aa&&(this.inputAA8x.checked=1)}catch(e){}e.dpr<1?this.showLowDprWarning():e.dpr>1&&this.showHighDprWarning()}}saveSettings(){var e,t,i;const s=this.inputResolutions.find((e=>e.checked)),o=this.config.resolutions.findIndex((e=>e.string===(null==s?void 0:s.value)));localStorage.setItem(c().debug?"kvg-settings-debug":"kvg-settings",JSON.stringify({muted:null===(e=this.inputMuted)||void 0===e?void 0:e.checked,lockAspect:null===(t=this.inputLockAspect)||void 0===t?void 0:t.checked,debug:null===(i=this.inputDebug)||void 0===i?void 0:i.checked,dpr:this.determineDPR(),resolution:o,aa:this.inputAAOff.checked?"0.0":this.inputAA2x.checked?"2.0":this.inputAA4x.checked?"4.0":this.inputAA8x.checked?"8.0":"0.0"}))}}const he=JSON.parse('{"title":"Exhibition","images":[],"shaderConstants":{"color1":"#58594C","color2":"#D8D9BF","color3":"#8C8A6D","color4":"#262626","color5":"#0D0D0D"},"beatsPerBar":4,"ticksPerBeat":16,"beatsPerMinute":80,"aspectRatio":{"string":"16:9","range":1.77777777777},"music":"eimink_-_sampled_atmosphere.mp3","generateFFT":true,"precision":2048,"debug":true,"muted":false,"looping":false,"enableKHRParallelCompilation":true,"analyserVersion":"modern","parts":[{"instanceId":"belt","start":[0,0,0],"end":[12,0,0]},{"instanceId":"duck","start":[12,0,0],"end":[18,0,0]},{"instanceId":"torus","start":[18,0,0],"end":[24,0,0]},{"instanceId":"cubetocube","start":[24,0,0],"end":[34,0,0]},{"instanceId":"balldrop","start":[34,0,0],"end":[37,0,0]},{"instanceId":"belt2","start":[37,0,0],"end":[46,0,0]},{"instanceId":"checkers","start":[46,0,0],"end":[50,0,0]},{"instanceId":"belt","start":[50,0,0],"end":[59,0,0]}]}');class ue extends class{constructor(e){this.id="",this.features=new Set([S.EnablePostProcess,S.EnableAudioAnalyzer]),this.renderAlwaysToScreen=0,this.renderToScreen=0,this.renderDebug=0,this.running=0,this.framebuffer=null,this.clearColor=[0,0,0,1],this.triggers=new Set,this.reactors=new Set,this.curves=new Set,this.onUpdate=e=>{this.update(e.timesig)},this.id=e}getTimelineEvents(){return[...[...this.triggers].map((e=>({startAt:e.triggerAt,type:C.Trigger}))),...[...this.reactors].map((e=>({startAt:e.start,endAt:e.end,type:C.Reactor}))),...[...this.curves].map((e=>({startAt:e.start,endAt:e.end,type:C.Curve})))]}runTriggers(e){this.curves.forEach((t=>{if(e.isInside(t.start,t.end,t.start.pattern==h.RELATIVE?this.timeline.start:void 0)){const i=t.start.toMilliseconds(),s=t.end.toMilliseconds(),o=e.toMilliseconds()-(t.start.pattern==h.RELATIVE?this.timeline.start.toMilliseconds():0);t.onUpdate(t.curve((o-i)/(s-i)))}})),this.reactors.forEach((t=>{e.isInside(t.start,t.end,t.start.pattern==h.RELATIVE?this.timeline.start:void 0)&&(t.onUpdate(e),t.pattern.matchesPattern(e,t.pattern)&&t.onPattern(e))})),this.triggers.forEach((t=>{null!=t.triggered?t.triggerAt.matchesPattern(e,this.timeline.start)&&(null!=t.reverse&&t.reverse(e),t.triggered=null):t.triggerAt.matchesPattern(e,this.timeline.start)&&t.forward(e)}))}update(e){}initPreCompile(){this.renderer=v.instance.renderer,this.context=this.renderer.context,this.features.has(S.EnableAudioAnalyzer)&&(this.analyser=new I(c().analyserVersion)),this.features.has(S.EnablePostProcess)&&(this.postProcessing=new A(this))}onStandardComplete(){}getPrograms(){if(this.postProcessing){const e=[];return this.postProcessing.posts.forEach((t=>{t.programs.forEach((t=>{e.push({program:t.program,fragmentShader:t.fragmentShader,vertexShader:t.vertexShader})}))})),e}return[]}init(){this.postProcessing&&this.postProcessing.posts.forEach((e=>e.programReady()))}updateProgram(e){}start(e,t){this.running||v.instance.onUpdate.connect(this.onUpdate),this.timeline=t,this.running=1}stop(){v.instance.onUpdate.disconnect(this.onUpdate),this.running=0}postInit(){}setFramebuffer(){this.renderer.context.bindFramebuffer(this.context.FRAMEBUFFER,this.framebuffer)}clearRendertarget(){this.context.clearColor(this.clearColor[0],this.clearColor[1],this.clearColor[2],this.clearColor[3]),this.context.clear(this.context.COLOR_BUFFER_BIT|this.context.DEPTH_BUFFER_BIT)}render(e,t,i){}preRender(e,t){this.analyser.update()}postRender(e,t,i){this.postProcessing&&i.render(this.renderTo,this.postProcessing)}addTrigger(e,t,i){const s={triggerAt:e,forward:t,reverse:i,triggered:null};return this.triggers.add(s),s}clearTrigger(e){this.triggers.delete(e)}addReactor(e,t,i,s,o){const r={start:e,end:t,pattern:i,onPattern:s,onUpdate:o};return this.reactors.add(r),r}removeReactor(e){this.reactors.delete(e)}addCurve(e,t,i,s){const o={start:e,end:t,onUpdate:i,curve:null!=s?s:e=>e};return this.curves.add(o),o}removeCurve(e){this.curves.delete(e)}}{constructor(e,t,i){super(e),this.uniforms=[],this.vertexShader=i,this.fragmentShader=t}init(){super.init()}getPrograms(){return[{vertexShader:this.vertexShader,fragmentShader:this.fragmentShader}].concat(super.getPrograms())}updateProgram(e){this.vertexShader=e[0].vertexShader,this.fragmentShader=e[0].fragmentShader,this.program=e[0].program}preRender(e,t){super.preRender(e,t),t.useProgram(this.program),this.uniforms.forEach((e=>e.sync()))}render(e,t,i){super.render(e,t,i),i.useProgram(this.program);var s=i.FLOAT;i.vertexAttribPointer(0,2,s,0,0,0);var o=i.TRIANGLES;i.drawArrays(o,0,3)}CreateUniform(e){var t=new q(this.program,this.context,e);return this.uniforms.push(t),t}}const de=e=>function(t){return Math.pow(t,e)},pe=e=>function(t){return 1-Math.pow(1-t,e)},me=e=>function(t){return(t*=2)<1?.5*Math.pow(t,e):1-.5*Math.abs(Math.pow(2-t,e))},fe=de(2),ve=pe(2),ge=me(2);de(3),pe(3),me(3),de(4),pe(4),me(4),de(5),pe(5),me(5),xe=1.7;var xe;const ye=e=>function(t){return--t*t*((e+1)*t+e)+1},be=ye(1.7),Re=((e=>{e*=1.525})(1.7),e=>e<1/2.75?7.5625*e*e:e<2/2.75?7.5625*(e-=1.5/2.75)*e+.75:e<2.5/2.75?7.5625*(e-=2.25/2.75)*e+.9375:7.5625*(e-=2.625/2.75)*e+.984375);Ee=1,Pe=.3,Te=2*Math.PI;var Ee,Pe,Te;((e,t)=>{var i=2*Math.PI})(1,.3),((e,t)=>{var i=2*Math.PI})(1,.3*1.5);var we=i(2),Ae=i.n(we);var Me=i(3),Ce=i.n(Me);var Se=i(4),Ie=i.n(Se);var Ue=i(5),Le=i.n(Ue);var Oe=i(6),ke=i.n(Oe);var De=i(7),ze=i.n(De);var Be=i(8),_e=i.n(Be);var qe=i(9),Fe=i.n(qe);var Ve=i(10),Ne=i.n(Ve);const He={exposure:1,contrast:1,brightness:0};new class{constructor(e){this._partInitalizers=[],this._postProcessInitializers=[],this._filterInitializer=void 0,this._postProcesses=new Map,this._filters=new Map,this._setupEventListeners={},this._onPartRender=void 0,this._config=e}isConstructor(e){return!!e.prototype}addPart(e){return this.isConstructor(e)?this._partInitalizers.push((()=>new e)):this._partInitalizers.push(e),this}addDefaultPost(e,t,i){return this._postProcessInitializers.push({name:null!=t?t:e.name,initializer:s=>{const o=new e(v.instance.renderer,s?{...i,...s}:i);return t&&(o.name=t),o}}),this}addDefaultAudioFilters(e){return this._filterInitializer=e,this}onSetup(e){if(this._setupEventListeners.onSetup)throw new Error("Only one onSetup allowed.");return this._setupEventListeners.onSetup=e,this}onBuilt(e){if(this._setupEventListeners.onSetup)throw new Error("Only one onBuilt allowed.");return this._setupEventListeners.onBuilt=e,this}onStart(e){if(this._setupEventListeners.onSetup)throw new Error("Only one onStart allowed.");return this._setupEventListeners.onStart=e,this}onPartRender(e){if(this._onPartRender)throw new Error("Only one onPartUpdate allowed");return this._onPartRender=e,this}buildParts(){return this._partInitalizers.map((e=>e()))}onPartPreCompile(e){const t={};this._postProcessInitializers.forEach((i=>{const s=Reflect.get(e,"common"),o=s?Reflect.get(s,i.name):{},r=i.initializer(o);e.postProcessing.attach(r,r.name),t[r.name]=r})),this._postProcesses.set(e.id,t)}onPartInit(e){var t;const i=null===(t=this._filterInitializer)||void 0===t?void 0:t.call(this,e);i&&this._filters.set(e.id,i)}update(e,t){var i;null===(i=this._onPartRender)||void 0===i||i.call(this,e,t,this._postProcesses.get(t.id),this._filters.get(t.id))}build(){return new le(this._config,this.buildParts(),this._setupEventListeners,{onPartPreCompile:e=>this.onPartPreCompile(e),onPartInit:e=>this.onPartInit(e),onPartRender:(e,t)=>this.update(e,t)}),this}}(he).addPart(class extends ue{constructor(){super("belt",Ce()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[0,0,-10]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,0,0]}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3,min:0,max:100}),this.phaseU=this.CreateUniform({name:"phase",type:_.f1,value:0,min:0,max:5}),this.noiseMultiplierU=this.CreateUniform({name:"noiseMultiplier",type:_.f1,value:.2,min:0,max:5}),this.volumetricStepMultiplierU=this.CreateUniform({name:"volumetricStepMultiplier",type:_.f1,value:1.2}),this.addCurve(new p(0,0,0,h.ABSOLUTE),new p(4,0,0,h.ABSOLUTE),(e=>{}));const e=this.postProcessing.As();this.addCurve(new p(0,0,0,h.ABSOLUTE),new p(4,0,0,h.ABSOLUTE),(t=>{e.ColorAdjustment.contrast.value=t})),this.addCurve(new p(50,0,0,h.ABSOLUTE),new p(55,0,0,h.ABSOLUTE),(e=>{this.fovU.value=t.lerp(3,4,1-ye(.6)(e)),this.targetU.value=t.lerpList([7.5,-.7,0],[8,-.7,0],ve(e))})),this.addTrigger(new p(4,0,0,h.ABSOLUTE),(e=>{this.phaseU.value=1})),this.addTrigger(new p(6,0,0,h.ABSOLUTE),(e=>{this.phaseU.value=2})),this.addTrigger(new p(8,0,0,h.ABSOLUTE),(e=>{this.cameraU.value=[-8.21,6.26,-5.08],this.targetU.value=[-7.53,6.12,-4.37],this.phaseU.value=3,this.volumetricStepMultiplierU.value=.9})),this.addTrigger(new p(50,0,0,h.ABSOLUTE),(t=>{this.phaseU.value=5,this.cameraU.value=[8,-.7,-27],this.noiseMultiplierU.value=.4,e.ColorAdjustment.contrast.value=1})),this.addCurve(new p(54,4,0,h.ABSOLUTE),new p(58,0,0,h.ABSOLUTE),(e=>{this.noiseMultiplierU.value=.4+2*e})),this.addCurve(new p(55,2,0,h.ABSOLUTE),new p(58,0,0,h.ABSOLUTE),(t=>{e.ColorAdjustment.contrast.value=1-t})),this.rumbaFilter=this.analyser.addFilter("rumba"),this.rumbaFilter.low=1e3,this.rumbaFilter.high=5e3,this.addCurve(new p(0,0,0,h.ABSOLUTE),new p(20,0,0,h.ABSOLUTE),(t=>{this.noiseMultiplierU.value=.3*this.rumbaFilter.result.max,e.ColorAdjustment.exposure.value=1.49}),(e=>e))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("checkers",Ae()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[.01,8,0]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:_.f3v,value:[0,4,0]}),this.light2U=this.CreateUniform({name:"light2",type:_.f3v,value:[4,3,0]}),this.light3U=this.CreateUniform({name:"light3",type:_.f3v,value:[0,6,1]}),this.cuberotU=this.CreateUniform({name:"cuberot",type:_.f3v,value:[0,0,0]}),this.cuberot2U=this.CreateUniform({name:"cuberot2",type:_.f3v,value:[0,0,0]}),this.cuberot3U=this.CreateUniform({name:"cuberot3",type:_.f3v,value:[0,0,0]}),this.cuberot4U=this.CreateUniform({name:"cuberot4",type:_.f3v,value:[0,0,0]}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(4,0,0,h.RELATIVE),(e=>{this.cameraU.value=[.01,25-23.5*e,0]}),(e=>e)),this.addCurve(new p(0,0,0,h.RELATIVE),new p(0,2,0,h.RELATIVE),(e=>{}),(e=>e)),this.addCurve(new p(1,0,0,h.RELATIVE),new p(1,2,0,h.RELATIVE),(e=>{this.cuberotU.value=[0,0,ge(e)*Math.PI/2]}),(e=>e)),this.addCurve(new p(2,0,0,h.RELATIVE),new p(2,2,0,h.RELATIVE),(e=>{this.cuberotU.value=[0,ge(e)*Math.PI/2,0]}),(e=>e)),this.addCurve(new p(3,0,0,h.RELATIVE),new p(3,2,0,h.RELATIVE),(e=>{this.cuberotU.value=[ge(e)*Math.PI/2,0,0]}),(e=>e)),this.addCurve(new p(1,1,0,h.RELATIVE),new p(1,3,0,h.RELATIVE),(e=>{this.cuberot2U.value=[0,0,ge(e)*Math.PI/2]}),(e=>e)),this.addCurve(new p(2,1,0,h.RELATIVE),new p(2,3,0,h.RELATIVE),(e=>{this.cuberot2U.value=[0,ge(e)*Math.PI/2,0]}),(e=>e)),this.addCurve(new p(3,1,0,h.RELATIVE),new p(3,3,0,h.RELATIVE),(e=>{this.cuberot2U.value=[ge(e)*Math.PI/2,0,0]}),(e=>e)),this.addCurve(new p(1,2,0,h.RELATIVE),new p(1,4,0,h.RELATIVE),(e=>{this.cuberot3U.value=[0,0,ge(e)*Math.PI/2]}),(e=>e)),this.addCurve(new p(2,2,0,h.RELATIVE),new p(2,4,0,h.RELATIVE),(e=>{this.cuberot3U.value=[0,ge(e)*Math.PI/2,0]}),(e=>e)),this.addCurve(new p(3,2,0,h.RELATIVE),new p(3,4,0,h.RELATIVE),(e=>{this.cuberot3U.value=[ge(e)*Math.PI/2,0,0]}),(e=>e)),this.addCurve(new p(1,3,0,h.RELATIVE),new p(1,5,0,h.RELATIVE),(e=>{this.cuberot4U.value=[0,0,ge(e)*Math.PI/2]}),(e=>e)),this.addCurve(new p(2,3,0,h.RELATIVE),new p(2,5,0,h.RELATIVE),(e=>{this.cuberot4U.value=[0,ge(e)*Math.PI/2,0]}),(e=>e)),this.addCurve(new p(3,3,0,h.RELATIVE),new p(3,5,0,h.RELATIVE),(e=>{this.cuberot4U.value=[ge(e)*Math.PI/2,0,0]}),(e=>e))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("torus",Ie()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.torus1U=this.CreateUniform({name:"torus1size",type:_.f1,value:0,min:0,max:2}),this.torus2U=this.CreateUniform({name:"torus2size",type:_.f1,value:0,min:0,max:2}),this.torus3U=this.CreateUniform({name:"torus3size",type:_.f1,value:0,min:0,max:2}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[7,7,7]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,-.5,0]}),this.light1U=this.CreateUniform({name:"light1",type:_.f3v,value:[0,4,0]}),this.light2U=this.CreateUniform({name:"light2",type:_.f3v,value:[4,3,0]}),this.light3U=this.CreateUniform({name:"light3",type:_.f3v,value:[0,6,1]}),this.cuberotU=this.CreateUniform({name:"cuberot",type:_.f3v,value:[0,0,0]}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(6,0,0,h.RELATIVE),(e=>{this.cuberotU.value=[e*Math.PI/2,5*e,4*e]}),(e=>e)),this.addCurve(new p(0,0,0,h.RELATIVE),new p(1,0,0,h.RELATIVE),(e=>{this.torus1U.value=.5*be(e)}),(e=>e)),this.addCurve(new p(1,3,0,h.RELATIVE),new p(2,3,0,h.RELATIVE),(e=>{this.torus1U.value=.5*be(e)+.5,this.torus2U.value=.5*be(e)}),(e=>e)),this.addCurve(new p(3,3,0,h.RELATIVE),new p(4,3,0,h.RELATIVE),(e=>{this.torus1U.value=.5*be(e)+1,this.torus2U.value=.5*be(e)+.5,this.torus3U.value=.5*be(e)}),(e=>e))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("balldrop",ke()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.torus1U=this.CreateUniform({name:"torus1size",type:_.f1,value:0,min:0,max:2}),this.torus2U=this.CreateUniform({name:"torus2size",type:_.f1,value:0,min:0,max:2}),this.torus3U=this.CreateUniform({name:"torus3size",type:_.f1,value:0,min:0,max:2}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[0,5,10]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:_.f3v,value:[8,4,9]}),this.light2U=this.CreateUniform({name:"light2",type:_.f3v,value:[1.89,16,9]}),this.light3U=this.CreateUniform({name:"light3",type:_.f3v,value:[8,4,-9]}),this.cubeposU=this.CreateUniform({name:"cubepos",type:_.f3v,value:[0,0,0]}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(2,2,0,h.RELATIVE),(e=>{this.cubeposU.value=[0,3.5*Re(e)-3,0]}),(e=>e))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("cubetocube",Le()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender]),this.offset=4}initPreCompile(){super.initPreCompile()}init(){super.init(),this.slider1U=this.CreateUniform({name:"slider1",type:_.f3v,value:[-this.offset,0,0],min:-2,max:2}),this.slider2U=this.CreateUniform({name:"slider2",type:_.f3v,value:[0,0,this.offset],min:-2,max:2}),this.slider3U=this.CreateUniform({name:"slider3",type:_.f3v,value:[0,this.offset,0],min:-2,max:2}),this.slider4U=this.CreateUniform({name:"slider4",type:_.f3v,value:[0,this.offset,0],min:-2,max:2}),this.slider5U=this.CreateUniform({name:"slider5",type:_.f3v,value:[0,0,this.offset],min:-2,max:2}),this.slider6U=this.CreateUniform({name:"slider6",type:_.f3v,value:[this.offset,0,0],min:-2,max:2}),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.torus1U=this.CreateUniform({name:"torus1size",type:_.f1,value:0,min:0,max:2}),this.torus2U=this.CreateUniform({name:"torus2size",type:_.f1,value:0,min:0,max:2}),this.torus3U=this.CreateUniform({name:"torus3size",type:_.f1,value:0,min:0,max:2}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:8}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[4.8,4.8,4.8]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,.85,0]}),this.light1U=this.CreateUniform({name:"light1",type:_.f3v,value:[20,3,20]}),this.light2U=this.CreateUniform({name:"light2",type:_.f3v,value:[9,9,9]}),this.light3U=this.CreateUniform({name:"light3",type:_.f3v,value:[10,10,10]}),this.cubeposU=this.CreateUniform({name:"cubepos",type:_.f3v,value:[0,0,0]}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(2,2,0,h.RELATIVE),(e=>{}),(e=>e)),this.generateZoom(new p(0,0,0,h.RELATIVE),1),this.generateZoom(new p(1,0,0,h.RELATIVE)),this.generateZoom(new p(2,0,0,h.RELATIVE)),this.generateZoom(new p(3,0,0,h.RELATIVE)),this.generateZoom(new p(4,0,0,h.RELATIVE)),this.generateZoom(new p(5,0,0,h.RELATIVE)),this.generateZoom(new p(6,0,0,h.RELATIVE)),this.generateZoom(new p(7,0,0,h.RELATIVE)),this.generateZoom(new p(8,0,0,h.RELATIVE)),this.generateZoom(new p(9,0,0,h.RELATIVE)),this.generateZoom(new p(10,0,0,h.RELATIVE))}generateZoom(e,i=1){i&&(this.addCurve(e.clone(),e.clone().addTicks(12),(e=>{this.slider6U.value=[-fe(e)*this.offset,0,0]}),(e=>1-e)),this.addCurve(e.clone().addTicks(6),e.clone().addTicks(18),(e=>{this.slider5U.value=[0,0,-fe(e)*this.offset]}),(e=>1-e)),this.addCurve(e.clone().addTicks(12),e.clone().addTicks(24),(e=>{this.slider4U.value=[0,-fe(e)*this.offset,0]}),(e=>1-e)),this.addCurve(e.clone().addTicks(18),e.clone().addTicks(30),(e=>{this.slider3U.value=[0,-fe(e)*this.offset,0]}),(e=>1-e)),this.addCurve(e.clone().addTicks(24),e.clone().addTicks(36),(e=>{this.slider2U.value=[0,0,-fe(e)*this.offset]}),(e=>1-e)),this.addCurve(e.clone().addTicks(30),e.clone().addTicks(42),(e=>{this.slider1U.value=[-fe(e)*this.offset,0,0]}),(e=>1-e))),this.addCurve(e.clone().addTicks(48),e.clone().addTicks(62),(e=>{this.cameraU.value=t.lerpList([4.8,4.8,4.8],[2.65,3.15,2.65],e),this.targetU.value=t.lerpList([0,.85,0],[0,.97,0],e)}),(e=>e)),this.addTrigger(e.clone().addTicks(62),(e=>{this.cameraU.value=t.lerpList([4.8,4.8,4.8],[2.65,3.15,2.65],0),this.targetU.value=t.lerpList([0,.85,0],[0,.975,0],0),this.slider1U.value=[-this.offset,0,0],this.slider2U.value=[0,0,-this.offset],this.slider3U.value=[0,-this.offset,0],this.slider4U.value=[0,-this.offset,0],this.slider5U.value=[0,0,-this.offset],this.slider6U.value=[-this.offset,0,0]}))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i);e.toMilliseconds()}}).addPart(class extends ue{constructor(){super("belt2",ze()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[1,1,-10]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,-.5,22.97]}),this.offsetU=this.CreateUniform({name:"offset",type:_.f3v,value:[0,0,0]}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3,min:0,max:100}),this.phaseU=this.CreateUniform({name:"phase",type:_.f1,value:0,min:0,max:5}),this.noiseMultiplierU=this.CreateUniform({name:"noiseMultiplier",type:_.f1,value:.2,min:0,max:5});const e=this.postProcessing.As();this.addCurve(new p(0,0,0,h.RELATIVE),new p(1,0,0,h.RELATIVE),(t=>{e.ColorAdjustment.contrast.value=t})),this.addTrigger(new p(2,0,0,h.RELATIVE),(e=>{this.offsetU.value=[-0,-1.72,0],this.cameraU.value=[0,0,-10],this.targetU.value=[18.92,7.3,39.19]})),this.addTrigger(new p(4,0,0,h.RELATIVE),(e=>{this.offsetU.value=[0,-1.72,0],this.cameraU.value=[2.9,0,-7.4],this.targetU.value=[0,0,0]})),this.addTrigger(new p(6,0,0,h.RELATIVE),(e=>{this.offsetU.value=[11,-2,1],this.cameraU.value=[4.4,5,21],this.targetU.value=[0,0,0]}))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("belt3",_e()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[0,0,-1]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,0,0]}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3,min:0,max:100}),this.phaseU=this.CreateUniform({name:"phase",type:_.f1,value:0,min:0,max:5}),this.noiseMultiplierU=this.CreateUniform({name:"noiseMultiplier",type:_.f1,value:.2,min:0,max:5}),this.inkdropSizeU=this.CreateUniform({name:"inkdropSize",type:_.f1,value:1});this.postProcessing.As();this.addCurve(new p(2,0,0,h.RELATIVE),new p(4,0,0,h.RELATIVE),(e=>{}),(e=>e))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*(e.toMilliseconds()-this.timeline.start.toMilliseconds())}render(e,t,i){super.render(e,t,i)}}).addPart(class extends ue{constructor(){super("duck",Fe()),this.features=new Set([S.DefaultAudioFilters,S.DefaultPostProcess,S.EnableAudioAnalyzer,S.EnablePostProcess,S.DefaultOnRender])}initPreCompile(){super.initPreCompile()}init(){super.init(),this.repeatU=this.CreateUniform({name:"repeat",type:_.f3v,value:[100,100,100]}),this.timeU=this.CreateUniform({name:"time",type:_.f1,value:0}),this.fovU=this.CreateUniform({name:"fov",type:_.f1,value:3}),this.cameraU=this.CreateUniform({name:"camera",type:_.f3v,value:[4.87,1.41,-.11]}),this.targetU=this.CreateUniform({name:"target",type:_.f3v,value:[0,0,0]}),this.light1U=this.CreateUniform({name:"light1",type:_.f3v,value:[8,4,9]}),this.light2U=this.CreateUniform({name:"light2",type:_.f3v,value:[1.89,16,9]}),this.light3U=this.CreateUniform({name:"light3",type:_.f3v,value:[8,4,-9]}),this.addCurve(new p(0,0,0,h.RELATIVE),new p(2,2,0,h.RELATIVE),(e=>{}),(e=>e)),this.addTrigger(new p(2,0,0,h.RELATIVE),(e=>{this.cameraU.value=[3.34,6.54,.12]})),this.addTrigger(new p(4,0,0,h.RELATIVE),(e=>{this.cameraU.value=[2.75,1.46,.73]}))}start(e,t){super.start(e,t),this.timeU.value=0}update(e){super.update(e),this.timeU.value=.001*e.toMilliseconds()}render(e,t,i){super.render(e,t,i)}}).addDefaultPost(class extends class{constructor(e,t,i){this.name="pp-base-class",this.enabled=1,this.compiled=0,this.renderer=e,this.programs=[{vertexShader:t,fragmentShader:i,program:e.context.createProgram()}],this.program=this.programs[0].program,this.uniforms=new Map}programReady(){this.compiled=1}buildUniforms(e,t){if(t||(t=this.program),!this.compiled)throw new Error("Accessing uniforms before compilation.");e&&(this.uniforms.has(t)||this.uniforms.set(t,new Map),e.forEach((e=>{const i=new q(t,this.renderer.context,e);this.uniforms.get(t).set(e.name,i)})))}render(e,t,i,s){e.bindFramebuffer(e.FRAMEBUFFER,t),e.useProgram(this.program),this.syncShader(this.uniforms.get(this.program)),e.drawArrays(e.TRIANGLES,0,3)}postRender(e,t,i,s){}syncShader(e){e.forEach((e=>e.sync()))}}{constructor(e,t){super(e,void 0,Ne()),this.name="ColorAdjustment",this.options={...He,...t}}programReady(){super.programReady(),this.buildUniforms([{name:"exposure",type:_.f1,value:this.options.exposure,min:0,max:5,generateDebugSlider:1},{name:"contrast",type:_.f1,value:this.options.contrast,min:0,max:5,generateDebugSlider:1},{name:"brightness",type:_.f1,value:this.options.brightness,min:-1,max:1,generateDebugSlider:1}],this.program),this.exposure=this.uniforms.get(this.program).get("exposure"),this.contrast=this.uniforms.get(this.program).get("contrast"),this.brightness=this.uniforms.get(this.program).get("brightness")}},"ColorAdjustment").build()})()})();